package cn.bestwu.gradle.profile

import cn.bestwu.gradle.profile.tasks.ProfileTask
import org.gradle.api.Plugin
import org.gradle.api.Project

/**
 *
 * 注册task
 *
 * @author Peter Wu
 */
class ProfilePlugin implements Plugin<Project> {

    @Override
    void apply(Project project) {
        project.configure(project) {
            project.extensions.create('profile', ProfileExtension)
            def taskGroup = 'app'
            project.task('alpha', type: ProfileTask, group: taskGroup, description: 'spring profile') {
                active 'alpha'
            }
            project.task('beta', type: ProfileTask, group: taskGroup, description: 'spring profile') {
                active 'beta'
            }
            project.task('release', type: ProfileTask, group: taskGroup, description: 'spring profile') {
                active 'release'
            }

        }
    }
}