package cn.bestwu.gradle.profile.tasks

import cn.bestwu.gradle.profile.ProfileExtension
import org.gradle.api.DefaultTask
import org.gradle.api.Project
import org.gradle.api.tasks.TaskAction

fun doProfileActivate(project: Project) {
    val profile = project.extensions.getByType(ProfileExtension::class.java)

    project.version = (if ("unspecified" == project.version) project.parent?.version else project.version).toString() + "." + profile.active.toUpperCase()

    profile.closure.forEach { it(project, profile) }
    if (profile.releases.contains(profile.active)) {
        profile.releaseClosure.forEach { it(project, profile) }
    }
}

/**
 * 激活特定Profile
 *
 * @author Peter Wu
 */
open class ProfileTask : DefaultTask() {

    @TaskAction
    fun run() {
        doProfileActivate(project)
    }
}