package cn.bestwu.gradle.profile

import org.gradle.api.Project
import org.gradle.language.jvm.tasks.ProcessResources
import java.io.File

/**
 * @author Peter Wu
 */
open class ProfileExtension(var defaultActive: String = "alpha",
                            var actives: Array<String> = arrayOf("beta", "release"),
                            var releases: Array<String> = arrayOf("release"),
                            var active: String = "alpha",
                            var source: String = "config",
                            var unwrapResources: Boolean = true,
                            private val defaultClosure: Project.(ProfileExtension) -> Unit = { extension ->
                                (project.tasks.getByName("processResources") as ProcessResources).filesMatching("application-*.yml") { f ->
                                    if (f.sourceName != "application-${extension.active}.yml") {
                                        f.exclude()
                                    }
                                }
                                if (file(extension.source).exists()) {
                                    val configDir = File("${extension.source}/${extension.active}")
                                    if (configDir.exists())
                                        copy {
                                            it.from(configDir.absolutePath)
                                            it.into(File("src/main/resources").absolutePath)
                                        }
                                }
                            },
                            var closure: Array<Project.(ProfileExtension) -> Unit> = arrayOf(defaultClosure),
                            var releaseClosure: Array<Project.(ProfileExtension) -> Unit> = arrayOf()) {

    val activeFileName: String
        get() = "$source/$active.properties"

    fun closure(closure: Project.(ProfileExtension) -> Unit) {
        this.closure += closure
    }

    fun releaseClosure(releaseClosure: Project.(ProfileExtension) -> Unit) {
        this.releaseClosure += releaseClosure
    }
}
