package cn.bestwu.gradle.tasks

import groovy.sql.Sql
import org.gradle.api.DefaultTask
import org.gradle.api.file.FileTree
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.TaskAction

class SQLTask extends DefaultTask {

    @Input
    String driver = 'com.mysql.jdbc.Driver'
    @Input
    String source = 'src/main/resources/sql'
    @Input
    String url
    @Input
    String username = 'root'
    @Input
    String password = 'root'

    @TaskAction
    def run() {
        def loader = GroovyObject.class.classLoader
        project.configurations.driver.each { File file ->
            loader.addURL file.toURI().toURL()
        }

        def props = [user: username, password: password, allowMultiQueries: 'true'] as Properties
        Sql.withInstance(url as String, props, driver, {
            sql ->
                fileTree().each({
                    if (it.isFile()) {
                        println 'execute: ' + it.getName()
                        sql.execute(it.text)
                    }
                });
        })
    }

    FileTree fileTree() {
        return project.files(source).getAsFileTree();
    }
}