package cn.bestwu.gradle.tasks

import org.gradle.api.tasks.Input
import org.gradle.api.tasks.OutputFile
import org.gradle.api.tasks.SourceTask
import org.gradle.api.tasks.TaskAction

class CombineFileTask extends SourceTask {
    @OutputFile
    def dest

    @Input
    String encoding = 'UTF-8'

    File getDest() {
        project.file(dest)
    }

    @TaskAction
    def run() {
        ant.concat(destfile: (dest as File).canonicalPath, fixlastline: 'yes', encoding: encoding) {
            source.files.each {
                logger.info("Adding to fileset: ${it}")
                fileset(file: it)
            }
        }
    }
}