package cn.bestwu.gradle.tasks

import org.gradle.api.tasks.Input
import org.gradle.api.tasks.OutputFile
import org.gradle.api.tasks.SourceTask
import org.gradle.api.tasks.TaskAction

class CombineExtJsTask extends SourceTask {

    @OutputFile
    def dest

    @Input
    String encoding = 'UTF-8'

    File getDest() {
        project.file(dest)
    }

    //合并extjs
    @TaskAction
    def run() {
        //处理 ExtJs js文件顺序
        def jsMap = new HashMap()
        def jsNames = new ArrayList()
        source.each {
            if (it.isFile()) {
                def map = new HashMap()
                map.put('file', it)

                def dependencies = new ArrayList()
                def lines = it.readLines()


                def size = lines.size()
                for (def i = 0; i < size; i++) {
                    def l = lines.get(i);
                    if (l.contains('extend:')) {
                        while (i < size && !l.contains(',')) {
                            l += lines.get(++i)
                        }
                        l = l.replaceAll(' ', '')
                        l.eachMatch(/extend:['|"](.*)['|"],/, { all, dependency ->
                            dependencies.add(dependency)
                        })
                    }
                    if (l.contains('requires:')) {
                        while (i < size && (!l.contains('],') && l.contains('[') || !l.contains(',') && !l.contains('['))) {
                            l += lines.get(++i)
                        }
                        l = l.replaceAll(' ', '')
                        l.eachMatch(/requires:\[?(.*)\]?,/, { all, dependencyText ->
                            dependencyText.splitEachLine(',', {
                                it.each {
                                    it.replaceAll(/['|"](.*)['|"]/) { dependencyTexts, dependency ->
                                        dependencies.add(dependency)
                                    }
                                }

                            })
                        })
                    }
                }

                map.put('dependencies', dependencies)

                it.getText(encoding).replaceAll(' ', '').eachMatch(/Ext\.define\('(.*)',/, { all, name ->
                    name = name.trim()
                    jsNames.add(name)
                    jsMap.put(name, map)
                })
            }

        }

        def jsList = new ArrayList()


        jsNames.toArray().each {
            jsList.addAll(getOrderedJs(it, jsMap))
        }
        //合并js
        def printWriter = (dest as File).newPrintWriter(encoding);
        jsList.each {
            def lines = it.readLines()


            int size = lines.size()
            for (int i = 0; i < size; i++) {
                def l = lines.get(i);

                if (l.contains('extend:')) {
                    while (i < size && !l.contains(',')) {
                        l += lines.get(++i)
                    }
                    l = l.replaceAll(' ', '')
                    l = l.replaceAll(/extend:['|"](.*)['|"],/, { all, text ->
                        "    extend: ${text},"
                    })
                } else if (l.contains('requires:')) {
                    while (i < size && (!l.contains('],') && l.contains('[') || !l.contains(',') && !l.contains('['))) {
                        l += lines.get(++i)
                    }
                    l = l.replaceAll(' ', '')
                    l = l.replaceAll(/requires:\[?(.*)\]?,/, '    requires: [],')
                }
                printWriter.println(l)
            }
        }
        printWriter.flush()
        printWriter.close()
    }

    def getOrderedJs(name, jsMap) {
        def jsList = new ArrayList()
        def js = jsMap.get(name)
        if (js == null)
            return jsList
        def file = js.get('file')
        def dependencies = js.get('dependencies')
        if (!dependencies.isEmpty()) {
            dependencies.each {
                jsList.addAll(getOrderedJs(it, jsMap))
            }
        }
        jsList.add(file)
        jsMap.remove(name)
        return jsList
    }


}

