package cn.bestwu.gradle.tasks

import org.gradle.api.DefaultTask
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.TaskAction
import org.yaml.snakeyaml.DumperOptions
import org.yaml.snakeyaml.Yaml

class ActiveProfileTask extends DefaultTask {

    @Input
    String encoding = 'UTF-8'
    @Input
    boolean yml = true
    @Input
    String source = 'src/main/resources/application.yml'
    @Input
    String profile = 'alpha'
    @Input
    Closure closure

    @TaskAction
    def run() {
        activeProfile(project)
    }

    def static activeProfile(project) {
        def profile = project.activeProfile.profile;
        def closure = project.activeProfile.closure;

        if (project.activeProfile.yml) {
            try {
                def source = project.activeProfile.source;
                def encoding = project.activeProfile.encoding;

                def dumperOptions = new DumperOptions()
                dumperOptions.setPrettyFlow(true)
                dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK)
                def yaml = new Yaml(dumperOptions)

                def ymlFile = new File(source)
                final def iterable = yaml.loadAll(ymlFile.newDataInputStream())
                def list = iterable.asList()
                final Map defaut = list.first() as Map
                defaut.put('spring.profiles.active', profile)
                yaml.dumpAll(list.iterator(), ymlFile.newWriter(encoding))
            } catch (ignored) {
            }
        }

        closure.call(profile)

        project.version = project.version + '.' + profile.toUpperCase();
    }
}