package cn.bestwu.generator.puml

import cn.bestwu.generator.database.domain.Table
import java.io.File
import java.io.PrintWriter

/**
 *
 * @author Peter Wu
 */
interface IToDDL {

    /**
     * 是否使用引号
     */
    var useQuote: Boolean
    /**
     * 生成SQL时是否生成外键相关语句
     */
    var useForeignKey: Boolean
    /**
     * 引号
     */
    val quoteMark: String
    /**
     * 注释前缀
     */
    val commentPrefix: String

    fun toDDL(src: File, out: File)

    fun toDDLUpdate(old: File, src: File, out: PrintWriter)

    fun appendTable(table: Table, pw: PrintWriter)
}