package cn.bestwu.generator.dsl.def

import cn.bestwu.generator.GeneratorExtension
import cn.bestwu.generator.database.domain.Column
import cn.bestwu.generator.dsl.Generator
import cn.bestwu.generator.dsl.Generators
import java.io.File

/**
 *
 * @author Peter Wu
 * @since 0.0.41
 */
class PlantUML(val output: String) : Generator() {

    companion object {
        var umlName: String? = null
    }

    override val extension: GeneratorExtension
        get() = GeneratorExtension()

    override val destFile: File
        get() = File(output)

    override fun setUp() {
        destFile.parentFile.mkdirs()
        destFile.writeText("""PK
FK
UNIQUE
INDEX

@startuml ${if (umlName.isNullOrBlank()) Generators.database else umlName}

""")
    }

    override fun doCall() {
        destFile.appendText("""class ${if (catalog.isNullOrBlank()) "" else "$catalog."}$tableName ${table.desc} {
    $remarks
    ==
""")
        table.pumlColumns.forEach {
            if (it is Column) {
                val isPrimary = it.isPrimary
                val isString = it.typeName.startsWith("VARCHAR")
                destFile.appendText("    ${it.columnName} : ${it.typeName}${if (it.columnSize > 0 && !arrayOf("DATE", "DATETIME").contains(it.typeName)) "(${it.columnSize}${if (it.decimalDigits > 0) ",${it.decimalDigits}" else ""})" else ""}${if (isPrimary) " PK" else if (it.unique) " UNIQUE" else if (it.indexed) " INDEX" else ""}${if (it.autoIncrement) " AUTO_INCREMENT" else ""}${if (it.columnDef.isNullOrBlank()) "" else " DEFAULT ${if (isString) "'" else ""}${it.columnDef}${if (isString) "'" else ""}"}${if (it.extra.isNotBlank()) " ${it.extra}" else ""}${if (it.nullable) " NULL" else " NOT NULL"} -- ${it.remarks}\n")
            } else {
                destFile.appendText("    $it\n")
            }

        }
        indexes.filter { it.columnName.size > 1 }.forEach {
            destFile.appendText("    '${if (it.unique) "UNIQUE" else "INDEX"} ${it.columnName.joinToString(",")}\n")
        }
        destFile.appendText("""}
                |
                |
            """.trimMargin())
    }

    override fun tearDown() {
        destFile.appendText("""
                |@enduml
            """.trimMargin())
    }

    fun appendlnText(text: String) {
        destFile.appendText(text + "\n\n")
    }
}