package cn.bestwu.generator.dsl

import cn.bestwu.generator.GeneratorExtension
import cn.bestwu.generator.dsl.def.PlantUML
import cn.bestwu.generator.puml.PumlConverter

/**
 * 模板脚本
 * @author Peter Wu

 */
object Generators {
    lateinit var extension: GeneratorExtension
    val database = "database"
    val puml = "puml"

    /**
     * @param extension 配置
     */
    fun call(extension: GeneratorExtension) {
        if (extension.generators.isEmpty()) {
            return
        }
        when (extension.dataType) {
            database -> database(extension)
            puml -> puml(extension)
        }
    }

    fun database(extension: GeneratorExtension) {
        this.extension = extension
        val generators = extension.generators
        if (generators.isEmpty()) {
            return
        }
        generators.forEach { generator ->
            generator.setUp()
        }

        extension.use {
            if (extension.tableNames.isEmpty()) {
                extension.use {
                    extension.tableNames = tableNames().toTypedArray()
                }
            }
            extension.tableNames.forEach {
                val table = table(it)
                generators.forEach { generator ->
                    generator.call(table)
                }
            }
        }
        generators.forEach { generator ->
            generator.tearDown()
        }
    }

    fun puml(extension: GeneratorExtension) {
        this.extension = extension
        val generators = extension.generators
        if (generators.isEmpty()) {
            return
        }
        generators.forEach { generator ->
            generator.setUp()
        }

        val emptyTableNames = extension.tableNames.isEmpty()
        val allTableNames = mutableSetOf<String>()
        val findTableNames = mutableSetOf<String>()
        extension.pumlSources.forEach { file ->
            val tables = PumlConverter.toTables(file)
            if (emptyTableNames) {
                tables.forEach { table ->
                    allTableNames.add(table.tableName)
                    println("查询：${table.tableName} 表数据结构")
                    generators.forEach { generator ->
                        generator.module = file.nameWithoutExtension
                        generator.moduleName = PlantUML.umlName!!
                        generator.call(table)
                    }
                }
            } else {
                allTableNames.addAll(tables.map { it.tableName })
                extension.tableNames.forEach { tableName ->
                    println("查询：$tableName 表数据结构")
                    val table = tables.find { it.tableName == tableName }
                    if (table != null) {
                        findTableNames.add(tableName)
                        generators.forEach { generator ->
                            generator.module = file.nameWithoutExtension
                            generator.moduleName = PlantUML.umlName!!
                            generator.call(table)
                        }
                    }
                }
            }
        }

        if (!emptyTableNames) {
            val notFound = extension.tableNames.find { !findTableNames.contains(it) }
            if (notFound != null)
                throw RuntimeException("未在($allTableNames)中找到${notFound}表")
        }

        generators.forEach { generator ->
            generator.tearDown()
        }
    }

}