package cn.bestwu.generator.database.domain

import cn.bestwu.generator.dsl.Generators.extension
import org.atteo.evo.inflector.English

/**
 *
 * 表对应数据模型类
 *
 * @author Peter Wu
 */
data class Table(
        val productName: String,
        val catalog: String?,
        val schema: String?,
        /**
         * 表名
         */
        val tableName: String,
        /**
         * 表类型
         */
        val tableType: String,
        /**
         * 注释说明
         */
        var remarks: String,
        /**
         * 主键
         */
        var primaryKeyNames: List<String>,
        val indexes: List<Indexed>,
        /**
         * 字段
         */
        var pumlColumns: List<Any>,
        var desc: String = "<<(T,#DDDDDD)>>",
        var sequenceStartWith: Int? = null) {

    val primaryKeys: MutableList<Column>
    val columns: MutableList<Column> = pumlColumns.asSequence().filter { it is Column }.map { it as Column }.toMutableList()

    init {
        val iterator = indexes.iterator()
        while (iterator.hasNext()) {
            val indexed = iterator.next()
            if (indexed.columnName.size == 1) {
                val column = columns.find { it.columnName == indexed.columnName[0] }!!
                column.indexed = true
                column.unique = indexed.unique
            }
        }
        primaryKeys = columns.asSequence().filter { primaryKeyNames.contains(it.columnName) }.toMutableList()
        primaryKeys.forEach { it.isPrimary = true }
    }


    val className
        get() = extension.className(tableName)

    val entityName
        get() = className.decapitalize()

    val pathName: String
        get() = English.plural(entityName)
}