package cn.bestwu.generator.database.domain

import cn.bestwu.generator.GeneratorExtension
import cn.bestwu.generator.dom.java.JavaType
import cn.bestwu.generator.dom.java.JavaTypeResolver
import cn.bestwu.generator.dom.java.PrimitiveTypeWrapper
import cn.bestwu.generator.dsl.Generator

/**
 * 字段
 *
 * @author Peter Wu
 */
data class Column(
        val tableCat: String?,
        val tableSchem: String?,
        /**
         * 数据库字段名
         */
        val columnName: String,
        /**
         * 数据库字段类型
         */
        var typeName: String,
        /**
         * 字段类型
         */
        val dataType: Int,
        /**
         * DECIMAL_DIGITS
         */
        var decimalDigits: Int,
        /**
         * COLUMN_SIZE
         */
        var columnSize: Int,
        /**
         * 注释说明
         */
        val remarks: String,
        /**
         * 是否可为空
         */
        val nullable: Boolean,
        /**
         * 默认值
         */
        val columnDef: String?,
        var extra: String = "",
        var unique: Boolean = false,
        var indexed: Boolean = false,
        var isPrimary: Boolean = false,
        var isForeignKey: Boolean = false,
        var pktableName: String? = null,
        var pkcolumnName: String? = null,
        var autoIncrement: Boolean = false,
        var generatedColumn: Boolean = false
) {
    val javaType: JavaType = JavaTypeResolver.calculateJavaType(this)!!
    val jdbcType: String = JavaTypeResolver.calculateJdbcTypeName(this)!!
    val javaName: String = GeneratorExtension.javaName(this.columnName)

    val randomValue: Any
        get() = when {
            columnDef.isNullOrBlank() -> when (javaType) {
                JavaType("java.math.BigDecimal") -> java.math.BigDecimal("1.0")
                JavaType("java.sql.Timestamp") -> (System.currentTimeMillis())
                JavaType.dateInstance -> (System.currentTimeMillis())
                JavaType("java.sql.Date") -> (System.currentTimeMillis())
                JavaType("java.sql.Time") -> (System.currentTimeMillis())
                PrimitiveTypeWrapper.booleanInstance -> true
                PrimitiveTypeWrapper.doubleInstance -> 1.0
                PrimitiveTypeWrapper.longInstance -> 1L
                PrimitiveTypeWrapper.integerInstance -> 1
                JavaType.stringInstance -> remarks.replace("\"", "\\\"")
                else -> 1
            }
            columnDef == "CURRENT_TIMESTAMP" -> (System.currentTimeMillis())
            else -> columnDef!!
        }

    val randomValueToSet: String
        get() = if (initializationString.isNullOrBlank()) {
            when (javaType) {
                JavaType("java.math.BigDecimal") -> "new java.math.BigDecimal(\"1.0\")"
                JavaType("java.sql.Timestamp") -> "new java.sql.Timestamp(System.currentTimeMillis())"
                JavaType.dateInstance -> "new java.util.Date(System.currentTimeMillis())"
                JavaType("java.sql.Date") -> "new java.sql.Date(System.currentTimeMillis())"
                JavaType("java.sql.Time") -> "new java.sql.Time(System.currentTimeMillis())"
                PrimitiveTypeWrapper.booleanInstance -> "true"
                PrimitiveTypeWrapper.doubleInstance -> "1.0"
                PrimitiveTypeWrapper.longInstance -> "1L"
                PrimitiveTypeWrapper.integerInstance -> "1"
                PrimitiveTypeWrapper.shortInstance -> "new Short(\"1\")"
                PrimitiveTypeWrapper.byteInstance -> "new Byte(\"1\")"
                JavaType("byte[]") -> "new byte[0]"
                JavaType.stringInstance -> "\"${remarks.replace("\"", "\\\"")}\""
                else -> "1"
            }
        } else {
            initializationString!!
        }

    val testId: Any
        get() = when (javaType) {
            JavaType.stringInstance -> "\"1\""
            PrimitiveTypeWrapper.longInstance -> "1L"
            PrimitiveTypeWrapper.integerInstance -> 1
            else -> 1
        }

    val initializationString
        get() = if (!columnDef.isNullOrBlank()) {
            when {
                columnDef == "CURRENT_TIMESTAMP" -> "new Date()"
                javaType.shortName == "Boolean" -> Generator.toBoolean(columnDef).toString()
                javaType.shortName == "Long" -> "${columnDef}L"
                javaType.shortName == "Double" -> "${columnDef}D"
                javaType.shortName == "Float" -> "${columnDef}F"
                javaType.shortName == "BigDecimal" -> "new BigDecimal($columnDef)"
                javaType.shortName == "String" -> "\"$columnDef\""
                else -> columnDef
            }
        } else {
            columnDef
        }
}