package cn.bestwu.generator.dsl

import cn.bestwu.generator.dom.java.JavaType
import cn.bestwu.generator.dom.java.element.*
import java.io.PrintWriter

/**
 *
 * @author Peter Wu
 */
abstract class JavaGenerator : Generator() {
    protected val compilationUnits: MutableList<CompilationUnit> = mutableListOf()

    protected abstract fun content()

    open var packageName: String = ""
        get() = if (field.isBlank()) extension.packageName else field

    override val dir: String
        get() = super.dir + "/" + packageName.replace('.', '/')

    protected val type: JavaType
        get() = if (moduleName.isNotBlank()) JavaType("$packageName.$moduleName.$name") else JavaType("$packageName.$name")
    protected open val domainJavaType: JavaType
        get() = if (moduleName.isNotBlank()) JavaType("$packageName.$moduleName.domain.$className") else JavaType("$packageName.domain.$className")

    override fun output(printWriter: PrintWriter) {
        JavaElement.indent = extension.indent
        compilationUnits.clear()
        content()
        compilationUnits.forEach {
            printWriter.println(it.formattedContent)
        }
    }

    protected fun interfaze(visibility: JavaVisibility = JavaVisibility.PUBLIC, interfaze: Interface.() -> Unit) {
        val value = Interface(type)
        value.visibility = visibility
        interfaze(value)
        compilationUnits.add(value)
    }

    protected fun clazz(visibility: JavaVisibility = JavaVisibility.PUBLIC, clazz: TopLevelClass.() -> Unit) {
        val value = TopLevelClass(type)
        value.visibility = visibility
        clazz(value)
        compilationUnits.add(value)
    }

    protected fun enum(enum: TopLevelEnumeration.() -> Unit) {
        val value = TopLevelEnumeration(type)
        enum(value)
        compilationUnits.add(value)
    }

}