package cn.bestwu.generator.dsl.def

import cn.bestwu.generator.GeneratorExtension
import cn.bestwu.generator.database.domain.Column
import cn.bestwu.generator.dsl.Generator
import java.io.File

/**
 *
 * @author Peter Wu
 * @since 0.0.41
 */
class PlantUML(val output: String) : Generator() {

    companion object {
        var umlName: String? = null
    }

    override val extension: GeneratorExtension
        get() = GeneratorExtension()

    override val destFile: File
        get() = File(output)

    override fun setUp() {
        destFile.parentFile.mkdirs()
        destFile.writeText("""PK
FK
UNIQUE
INDEX

@startuml ${if (umlName.isNullOrBlank()) "database" else umlName}

""")
    }

    override fun doCall() {
        destFile.appendText("""class ${if (catalog.isNullOrBlank()) "" else "$catalog."}$tableName ${if (table.desc.isNullOrBlank()) "<<(T,#DDDDDD)>>" else table.desc} {
    $comment
    ==
""")
        table.pumlColumns.forEach {
            if (it is Column) {
                val isString = it.typeName.startsWith("VARCHAR")
                destFile.appendText("    ${it.columnName} : ${it.typeName}${if (it.length > 0) "(${it.length}${if (it.scale > 0) ",${it.scale}" else ""})" else ""}${if (it.defaultVal.isNullOrBlank()) "" else " DEFAULT ${if (isString) "'" else ""}${it.defaultVal}${if (isString) "'" else ""}"}${if (it.isPrimary) " PK" else "${if (it.nullable) " NULL" else " NOT NULL"}${if (it.unique) " UNIQUE" else {
                    if (it.indexed) " INDEX" else ""
                }}"} -- ${it.comment}\n")
            } else {
                destFile.appendText("    ${it.toString()}\n")
            }

        }
        indexes.filter { it.columnName.size > 1 }.forEach {
            destFile.appendText("    '${if (it.unique) "UNIQUE" else "INDEX"} ${it.columnName.joinToString(",")}\n")
        }
        destFile.appendText("""}
                |
                |
            """.trimMargin())
    }

    override fun tearDown() {
        destFile.appendText("""
                |@enduml
            """.trimMargin())
    }

    fun appendlnText(text: String) {
        destFile.appendText(text + "\n\n")
    }
}