package cn.bestwu.generator.database.domain

/**
 *
 * 表对应数据模型类
 *
 * @author Peter Wu
 */
data class Table(
        val productName: String,
        val catalog: String? = null,
        val schema: String? = null,
        /**
         * 表名
         */
        val tableName: String,
        /**
         * 表类型
         */
        val tableType: String = "",
        /**
         * 注释说明
         */
        var comment: String = "",
        /**
         * 主键
         */
        val primaryKeys: MutableList<Column> = mutableListOf(),
        val indexes: MutableList<Indexed> = mutableListOf(),
        /**
         * 字段
         */
        var pumlColumns: MutableList<in Any> = mutableListOf(),
        var desc: String? = null,
        var withSequence: Boolean = false) {

    init {
        val iterator = indexes.iterator()
        while (iterator.hasNext()) {
            val indexed = iterator.next()
            if (indexed.columnName.size == 1) {
                val column = columns.find { it.columnName == indexed.columnName[0] }!!
                column.indexed = true
                column.unique = indexed.unique
            }
        }
    }

    val columns: List<Column>
        get() = pumlColumns.filter { it is Column }.map { it as Column }

    val primaryKeyNames: List<String>
        get() = primaryKeys.map { it.columnName }
}