package cn.bestwu.generator.database.domain

/**
 * 字段
 *
 * @author Peter Wu
 */
data class Column(
        val tableCat: String?,
        val tableSchem: String?,
        /**
         * 数据库字段名
         */
        val columnName: String,
        /**
         * 数据库字段类型
         */
        var typeName: String,
        /**
         * 字段类型
         */
        val dataType: Int,
        /**
         * DECIMAL_DIGITS
         */
        val scale: Int,
        /**
         * 限制长度
         */
        var length: Int,
        /**
         * 注释说明
         */
        val comment: String,
        /**
         * 是否可为空
         */
        val nullable: Boolean,
        /**
         * 默认值
         */
        val defaultVal: String?,
        var autoIncrement: Boolean = false,
        var unique: Boolean = false,
        var indexed: Boolean = false,
        var foreignKey: Boolean = false,
        var refTable: String? = null,
        var refColumn: String? = null,
        var generatedColumn: Boolean = false)