package cn.bestwu.generator.dsl

import cn.bestwu.generator.GeneratorExtension
import dsl.*

/**
 * 模板脚本
 * @author Peter Wu

 */
object Generators {

    /**
     * @param extension 配置
     * @return 结果
     */
    fun call(extension: GeneratorExtension): Any {
        val results = mutableListOf<Any>()
        extension.use {
            tables(*extension.tableNames).forEach {
                extension.generators.forEach { generator ->
                    results.add(generator.call(extension, it))
                }
            }
        }
        return results
    }

    /**
     * 生成字段
     */
    val field: Field
        get() = Field()
    /**
     * 生成domain
     */
    val domain: Domain
        get() = Domain()
    /**
     * 生成JPA domain
     */
    val domainJPA: DomainJPA
        get() = DomainJPA()
    /**
     * 生成 crud dao
     */
    val crudDao: CrudDao
        get() = CrudDao()

    /**
     * Mybatis
     */
    val mybatis: Mybatis
        get() = Mybatis()

}