package cn.bestwu.generator.dsl

import cn.bestwu.generator.GeneratorExtension
import cn.bestwu.generator.puml.PumlConverter

/**
 * 模板脚本
 * @author Peter Wu

 */
object Generators {
    lateinit var extension: GeneratorExtension
    /**
     * @param extension 配置
     */
    fun call(extension: GeneratorExtension) {
        this.extension = extension
        val generators = extension.generators
        generators.forEach { generator ->
            generator.setUp()
        }

        when (extension.dataType) {
            "database" -> extension.use {
                extension.tableNames.forEach {
                    try {
                        val table = table(it)
                        generators.forEach { generator ->
                            generator.call(table)
                        }
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                }
            }
            "puml" -> {
                val tables = extension.pumlSources.map { PumlConverter.toTables(it) }.flatten()
                try {
                    extension.tableNames.forEach { tableName ->
                        println("查询：$tableName 表数据结构")
                        val table = tables.find { it.tableName == tableName }
                                ?: throw RuntimeException("未在(${tables.joinToString(",") { it.tableName }})中找到${tableName}表")
                        generators.forEach { generator ->
                            generator.call(table)
                        }
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
        }

        generators.forEach { generator ->
            generator.tearDown()
        }
    }

}