package cn.bestwu.generator.database

/**
 *
 * 表对应数据模型类
 *
 * @author Peter Wu
 */
data class Table(
        val productName: String,
        val catalog: String? = null,
        val schema: String? = null,
        /**
         * 表名
         */
        val tableName: String,
        /**
         * 表类型
         */
        val tableType: String,
        /**
         * 注释说明
         */
        val comment: String,
        /**
         * 主键
         */
        val primaryKeys: List<Column>,
        val indexes: MutableList<Indexed>,
        /**
         * 字段
         */
        val columns: List<Column>) {

    init {
        val iterator = indexes.iterator()
        while (iterator.hasNext()){
            val indexed=iterator.next()
            if (indexed.columnName.size == 1) {
                val column = columns.find { it.columnName == indexed.columnName[0] }!!
                column.indexed = true
                column.unique = indexed.unique
                iterator.remove()
            }
        }
    }

    val primaryKeyNames: List<String>
        get() = primaryKeys.map { it.columnName }
}

data class Indexed(
        val name: String,
        val unique: Boolean = false,
        val columnName: MutableList<String> = mutableListOf()
)

/**
 * 字段
 *
 * @author Peter Wu
 */
data class Column(
        val tableCat: String?,
        val tableSchem: String?,
        /**
         * 数据库字段名
         */
        val columnName: String,
        /**
         * 数据库字段类型
         */
        val typeName: String,
        /**
         * 字段类型
         */
        val dataType: Int,
        /**
         * DECIMAL_DIGITS
         */
        val scale: Int,
        /**
         * 限制长度
         */
        val length: Int,
        /**
         * 注释说明
         */
        val comment: String,
        /**
         * 是否可为空
         */
        val nullable: Boolean,
        /**
         * 默认值
         */
        val defaultVal: String?,
        var autoIncrement: Boolean = false,
        var unique: Boolean = false,
        var indexed: Boolean = false,
        var generatedColumn: Boolean = false)
