package cn.bestwu.generator.dsl.def

import cn.bestwu.generator.dsl.Generator
import java.io.File

/**
 *
 * @author Peter Wu
 * @since 0.0.41
 */
class PlantUML : Generator() {

    override val destFile: File
        get() = File(extension.pumlDir, "db.puml")

    override fun setUp() {
        if (!extension.pumlDir.isNullOrBlank()) {
            destFile.writeText("""PK
FK
UNIQUE
INDEX

@startuml database

""")
        }
    }

    override fun doCall() {
        if (!extension.pumlDir.isNullOrBlank()) {
            destFile.appendText("""class $tableName <<(T,#DDDDDD)>> {
    $comment
    ==
""")
            columns.forEach {
                destFile.appendText("    ${it.columnName} : ${it.typeName}${if (it.length > 0) "(${it.length}${if (it.scale > 0) ",${it.scale}" else ""})" else ""} ${if (it.isPrimary) "PK" else "${if (it.nullable) "NULL" else "NOT NULL"} ${if (it.unique) "UNIQUE" else {
                    if (it.indexed) "INDEX" else ""
                }}"} -- ${it.comment}\n")
            }
            indexes.forEach {
                destFile.appendText("    '${if(it.unique) "UNIQUE" else "INDEX"} ${it.columnName.joinToString(",")}\n")
            }
            destFile.appendText("""}
                |
                |
            """.trimMargin())
        }
    }

    override fun tearDown() {
        if (!extension.pumlDir.isNullOrBlank()) {
            destFile.appendText("""
                |
                |@enduml
            """.trimMargin())
        }
    }
}