package cn.bestwu.generator.dsl

import cn.bestwu.generator.GeneratorExtension

/**
 * 模板脚本
 * @author Peter Wu

 */
object Generators {

    /**
     * @param extension 配置
     * @return 结果
     */
    fun call(extension: GeneratorExtension) {
        val generators = extension.generators
        generators.forEach { generator ->
            generator.extension = extension
            generator.setUp()
        }
        extension.use {
            extension.tableNames.forEach {
                try {
                    val table = table(it)
                    generators.forEach { generator ->
                        generator.call(table)
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
        }
        generators.forEach { generator ->
            generator.tearDown()
        }
    }

}