package dsl

import cn.bestwu.generator.dsl.Generator
import com.beust.klaxon.JsonArray
import com.beust.klaxon.Parser

/**
 * @author Peter Wu
 */
class Field : Generator() {

    var fileName: String = ""

    override val name: String
        get() = if (fileName.isBlank()) "$tableName.json" else fileName

    override fun doCall(): Any {
        if (destFile.exists() && ((!extension.replaceAll && !cover) || destFile.readLines().any { it.contains("[[Don't cover]]") })) {
            return destFile
        }
        destFile.parentFile.mkdirs()
        var json: JsonArray<Map<String, Any?>> = JsonArray()
        @Suppress("UNCHECKED_CAST")
        if (path.exists())
            try {
                json = Parser().parse(destFile.inputStream()) as JsonArray<Map<String, Any?>>
            } catch (ignore: Exception) {
            }
        columns.forEach {
            var type = if (it.length > 0) "${it.javaType.shortNameWithoutTypeArguments}(${it.length})" else it.javaType.shortNameWithoutTypeArguments
            if (type == "Date")
                type = "Long"
            val field = mutableMapOf(
                    "desc" to if (it.comment.isEmpty()) "" else it.comment,
                    "name" to it.javaName,
                    "nullable" to it.nullable,
                    "type" to type,
                    "value" to it.defaultVal
            )
            var existField = json.find {
                (field["desc"].toString().isBlank() || field["desc"] == it["desc"]) && field["name"] == it["name"] && field["notNull"] == it["notNull"] && field["type"] == it["type"] && field["value"] == it["value"]
            }
            if (existField == null) {
                if (json.find {
                            field["name"] == it["name"] && field["type"] == it["type"]
                        } != null) {
                    field["id"] = "${className}_${field["name"]}"

                    existField = json.find {
                        field["id"] == it["id"]
                    }
                    if (existField != null) {
                        json.remove(existField)
                    }
                }
                json.add(field)
            }
        }
        val msg = if (destFile.exists()) "覆盖" else "生成"
        destFile.printWriter().use {
            it.println(json.toJsonString(true))
        }
        println("$msg：$destFile")
        return destFile
    }

}