package dsl

import cn.bestwu.generator.dom.java.JavaType
import cn.bestwu.generator.dom.java.element.Parameter
import cn.bestwu.generator.dsl.JavaGenerator

/**
 * @author Peter Wu
 */
class Domain : JavaGenerator() {

    override var cover: Boolean = true
    override val name: String
        get() = "domain.$className"


    override fun content() {
        clazz {
            javadoc {
                +"/**"
                +" * $comment 对应表名：$tableName"
                +" */"
            }
            implement {
                +"java.io.Serializable"
            }
            serialVersionUID()
            columns.forEach {
                //field
                field(it.javaName, it.javaType) {
                    if (it.comment.isNotBlank())
                        if (it.comment.isNotBlank() || !it.defaultVal.isNullOrBlank())
                            javadoc {
                                +"/**"
                                +" * ${it.comment} ${if (it.defaultVal.isNullOrBlank()) "" else "默认值：${it.defaultVal}"}"
                                +" */"
                            }
                    if (!it.isPrimary) {
                        if (it.length > 0 && it.javaType == JavaType.stringInstance) {
                            annotation("@org.hibernate.validator.constraints.Length(max = ${it.length})")
                        }
                        if (!it.nullable) {
                            if (it.javaType == JavaType.stringInstance) {
                                annotation("@org.hibernate.validator.constraints.NotBlank")
                            } else {
                                annotation("@javax.validation.constraints.NotNull")
                            }
                        }
                    }
                    if (!it.defaultVal.isNullOrBlank() && !it.defaultVal.equals("null", true))
                        initializationString = it.initializationString
                }
            }

            //constructor no args
            constructor {}
            //constructor with id
            constructor(Parameter(primaryKey.javaName, primaryKey.javaType)) {
                +"this.${primaryKey.javaName} = ${primaryKey.javaName};"
            }

            columns.forEach {
                //getter
                method("get${it.javaName.capitalize()}", it.javaType) {
                    if (it.comment.isNotBlank() || !it.defaultVal.isNullOrBlank())
                        javadoc {
                            +"/**"
                            +" * @return ${(if (it.comment.isBlank()) "" else it.comment)} ${if (it.defaultVal.isNullOrBlank()) "" else "默认值：${it.defaultVal}"}"
                            +" */"
                        }
                    +"return ${it.javaName};"
                }
                //setter
                method("set${it.javaName.capitalize()}") {
                    if (it.comment.isNotBlank() || !it.defaultVal.isNullOrBlank())
                        javadoc {
                            +"/**"
                            +" * @param  ${if (it.comment.isBlank()) "" else "${it.javaName} ${it.comment}"} ${if (it.defaultVal.isNullOrBlank()) "" else "默认值：${it.defaultVal}"}"
                            +" */"
                        }
                    parameter {
                        type = it.javaType
                        name = it.javaName
                    }
                    +"this.${it.javaName} = ${it.javaName};"
                }
            }
        }
    }
}