package cn.bestwu.generator.dsl

import java.io.File
import java.io.PrintWriter

abstract class GeneratorWithPackageName : GeneratorWithPath() {

    open var packageName: String = ""
        get() = if (field.isBlank()) extension.packageName else field
    /**
     * 文件名称
     */
    protected abstract val name: String
    protected open val test: Boolean = false

    protected abstract fun output(printWriter: PrintWriter)

    override fun doCall(): Any {
        var packagePath = File((if (test) path.replace("src/main/", "src/test/") else path), packageName.replace('.', '/'))
        if (moduleName.isNotBlank()) {
            packagePath = File(packagePath, moduleName)
        }
        val destFile = File(packagePath, if (this is JavaGenerator) "${name.replace(".", "/")}.java" else name)
        destFile.parentFile.mkdirs()
        if (destFile.exists() && ((!extension.replaceAll && !cover) || destFile.readLines().any { it.contains("[[Don't cover]]") })) {
            return destFile
        }
        val msg = if (destFile.exists()) "覆盖" else "生成"
        destFile.printWriter().use {
            output(it)
        }
        println("$msg：$destFile")
        return destFile
    }
}