package dsl

import cn.bestwu.generator.dsl.GeneratorWithPath
import com.beust.klaxon.JsonArray
import com.beust.klaxon.Parser
import java.io.File

/**
 * @author Peter Wu
 */
class Field : GeneratorWithPath() {

    override fun doCall(): Any {
        var outputFile: File? = null
        var json: JsonArray<Map<String, Any?>> = JsonArray()
        if (!path.isBlank()) {
            outputFile = File(path)
            if (outputFile.isDirectory || (!outputFile.exists() && outputFile.extension.isBlank()))
                outputFile = File(path, "$tableName.json")
            @Suppress("UNCHECKED_CAST")
            if (outputFile.exists())
                try {
                    json = Parser().parse(outputFile.inputStream()) as JsonArray<Map<String, Any?>>
                } catch (ignore: Exception) {
                }
        }
        columns.forEach {
            var type = if (it.length > 0) "${it.javaType.shortNameWithoutTypeArguments}(${it.length})" else it.javaType.shortNameWithoutTypeArguments
            if (type == "Date")
                type = "Long"
            val field = mutableMapOf(
                    "desc" to if (it.comment.isEmpty()) "" else it.comment,
                    "name" to it.javaName,
                    "nullable" to it.nullable,
                    "type" to type,
                    "value" to it.defaultVal
            )
            var existField = json.find {
                field["desc"] == it["desc"] && field["name"] == it["name"] && field["notNull"] == it["notNull"] && field["type"] == it["type"] && field["value"] == it["value"]
            }
            if (existField == null) {
                if (json.find {
                            field["name"] == it["name"] && field["type"] == it["type"]
                        } != null) {
                    field["id"] = "${className}_${field["name"]}"

                    existField = json.find {
                        field["id"] == it["id"]
                    }
                    if (existField != null) {
                        json.remove(existField)
                    }
                }
                json.add(field)
            }
        }

        if (outputFile == null) {
            return json
        } else {
            outputFile.parentFile.mkdirs()
            outputFile.writeText(json.toJsonString(true))
            println("生成：$outputFile")
            return outputFile
        }
    }

}