/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.support;

import org.springframework.util.Assert;

public abstract class Version {
    public static String DEFAULT_VERSION = "1.0";
    public static String VERSION_PARAM_NAME = "version";

    public static int compareVersion(String version1, String version2) {
        String[] version2s;
        if (version1.equals(version2)) {
            return 0;
        }
        String separator = "[\\.-]";
        String[] version1s = version1.split(separator);
        boolean vl = version1s.length < (version2s = version2.split(separator)).length;
        int length = vl ? version1s.length : version2s.length;
        for (int i = 0; i < length; ++i) {
            try {
                int v2 = Integer.parseInt(version2s[i]);
                int v1 = Integer.parseInt(version1s[i]);
                if (v2 > v1) {
                    return -1;
                }
                if (v2 >= v1) continue;
                return 1;
            }
            catch (NumberFormatException e) {
                int result = version1s[i].compareTo(version2s[i]);
                if (result == 0) continue;
                return result;
            }
        }
        if (vl) {
            return -1;
        }
        if (version1s.length > version2s.length) {
            return 1;
        }
        return 0;
    }

    public static boolean included(String version1, String version2) {
        return version1.contains(version2) || version1.matches(version2);
    }

    public static boolean equals(String version1, String version2) {
        Assert.notNull((Object)version1);
        return version1.equalsIgnoreCase(version2);
    }
}

