/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.support;

import cn.bestwu.lang.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.mail.MailSendException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.StringUtils;

public class MailClient {
    private static final Logger log = LoggerFactory.getLogger(MailClient.class);
    private final JavaMailSenderImpl mailSender;
    private String from;
    private final String alias;

    public MailClient(JavaMailSenderImpl mailSender, MailProperties properties) {
        this.mailSender = mailSender;
        this.from = (String)properties.getProperties().get("from");
        if (this.from == null) {
            this.from = properties.getUsername();
        }
        this.alias = (String)properties.getProperties().get("alias");
    }

    public void send(String subject, String content, String ... mailTo) throws UnsupportedEncodingException, MessagingException {
        this.send(subject, content, (Map<String, String>)null, mailTo);
    }

    public void send(String subject, String content, Map<String, String> inlineFiles, String ... mailTo) throws MessagingException, UnsupportedEncodingException {
        block8: {
            if (log.isDebugEnabled()) {
                log.debug("\u6b63\u5728\u7ed9" + StringUtil.valueOf((Object)mailTo) + "\u53d1\u9001\u90ae\u4ef6");
            }
            MimeMessage mimeMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
            if (StringUtils.hasText((String)this.alias)) {
                helper.setFrom(this.from, this.alias);
            } else {
                helper.setFrom(this.from);
            }
            helper.setTo(mailTo);
            helper.setSubject(subject);
            helper.setText(content, true);
            if (inlineFiles != null) {
                Set<Map.Entry<String, String>> entrySet = inlineFiles.entrySet();
                for (Map.Entry<String, String> entry : entrySet) {
                    helper.addInline(entry.getKey(), (Resource)new FileSystemResource(entry.getValue()));
                }
            }
            try {
                this.mailSender.send(mimeMessage);
            }
            catch (MailSendException e) {
                if (!log.isWarnEnabled()) break block8;
                log.warn("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u90ae\u4ef6\u53d1\u9001\u5b8c\u6210");
        }
    }
}

