/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.resolver;

import com.querydsl.core.types.Predicate;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.data.querydsl.binding.FixQuerydslPredicateBuilder;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class QuerydslPredicateArgumentResolver
implements HandlerMethodArgumentResolver {
    private final QuerydslBindingsFactory bindingsFactory;
    private final FixQuerydslPredicateBuilder predicateBuilder;

    public QuerydslPredicateArgumentResolver(QuerydslBindingsFactory bindingsFactory, FixQuerydslPredicateBuilder predicateBuilder) {
        this.bindingsFactory = bindingsFactory;
        this.predicateBuilder = predicateBuilder;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        if (Predicate.class.equals((Object)parameter.getParameterType())) {
            return true;
        }
        if (parameter.hasParameterAnnotation(QuerydslPredicate.class)) {
            throw new IllegalArgumentException(String.format("Parameter at position %s must be of type Predicate but was %s.", parameter.getParameterIndex(), parameter.getParameterType()));
        }
        return false;
    }

    public Predicate resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        for (Map.Entry entry : webRequest.getParameterMap().entrySet()) {
            parameters.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
        QuerydslPredicate annotation = (QuerydslPredicate)parameter.getParameterAnnotation(QuerydslPredicate.class);
        TypeInformation typeInformation = QuerydslPredicateArgumentResolver.extractTypeInfo(parameter).getActualType();
        Class customizer = annotation == null ? null : annotation.bindings();
        QuerydslBindings bindings = this.bindingsFactory.createBindingsFor(customizer, typeInformation);
        return this.predicateBuilder.getPredicate(typeInformation, (MultiValueMap<String, String>)parameters, bindings);
    }

    static TypeInformation<?> extractTypeInfo(MethodParameter parameter) {
        QuerydslPredicate annotation = (QuerydslPredicate)parameter.getParameterAnnotation(QuerydslPredicate.class);
        if (annotation != null && !Object.class.equals((Object)annotation.root())) {
            return ClassTypeInformation.from((Class)annotation.root());
        }
        return QuerydslPredicateArgumentResolver.detectModelType(ClassTypeInformation.fromReturnTypeOf((Method)parameter.getMethod()));
    }

    private static TypeInformation<?> detectModelType(TypeInformation<?> source) {
        if (source.getTypeArguments().isEmpty()) {
            return source;
        }
        TypeInformation actualType = source.getActualType();
        if (source != actualType) {
            return QuerydslPredicateArgumentResolver.detectModelType(actualType);
        }
        if (source instanceof Iterable) {
            return source;
        }
        return QuerydslPredicateArgumentResolver.detectModelType(source.getComponentType());
    }
}

