/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.resolver;

import cn.bestwu.framework.data.query.LuceneSort;
import cn.bestwu.lang.util.BooleanUtil;
import java.util.ArrayList;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class LuceneSortHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String DEFAULT_PARAMETER = "lucenceSort";
    private static final String DEFAULT_PROPERTY_DELIMITER = ",";
    private static final String DEFAULT_QUALIFIER_DELIMITER = "_";
    private String sortParameter = "lucenceSort";
    private String propertyDelimiter = ",";
    private String qualifierDelimiter = "_";

    public void setSortParameter(String sortParameter) {
        Assert.hasText((String)sortParameter);
        this.sortParameter = sortParameter;
    }

    public void setPropertyDelimiter(String propertyDelimiter) {
        Assert.hasText((String)propertyDelimiter, (String)"Property delimiter must not be null or empty!");
        this.propertyDelimiter = propertyDelimiter;
    }

    public void setQualifierDelimiter(String qualifierDelimiter) {
        this.qualifierDelimiter = qualifierDelimiter == null ? DEFAULT_QUALIFIER_DELIMITER : qualifierDelimiter;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return LuceneSort.class.equals((Object)parameter.getParameterType());
    }

    public LuceneSort resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        String[] directionParameter = webRequest.getParameterValues(this.getSortParameter(parameter));
        if (directionParameter == null) {
            return null;
        }
        if (directionParameter.length == 1 && !StringUtils.hasText((String)directionParameter[0])) {
            return null;
        }
        return this.parseParameterIntoSort(directionParameter, this.propertyDelimiter);
    }

    protected String getSortParameter(MethodParameter parameter) {
        StringBuilder builder = new StringBuilder();
        if (parameter != null && parameter.hasParameterAnnotation(Qualifier.class)) {
            builder.append(((Qualifier)parameter.getParameterAnnotation(Qualifier.class)).value()).append(this.qualifierDelimiter);
        }
        return builder.append(this.sortParameter).toString();
    }

    private LuceneSort parseParameterIntoSort(String[] source, String delimiter) {
        ArrayList<SortField> allOrders = new ArrayList<SortField>();
        for (String part : source) {
            if (part == null) continue;
            String[] elements = part.split(delimiter);
            int length = elements.length;
            Boolean reverse = length < 2 ? null : BooleanUtil.toBooleanObject((String)elements[length - 1]);
            SortField.Type type = null;
            if (length >= 1) {
                type = reverse == null ? this.getType(elements[length - 1]) : this.getType(elements[length - 2]);
            }
            for (int i = 0; i < length; ++i) {
                if (i == length - 1 && (reverse != null || type != null) || i == length - 2 && type != null) {
                    if (length != 1) continue;
                    allOrders.add(new SortField(null, type));
                    continue;
                }
                String property = elements[i];
                if (!StringUtils.hasText((String)property)) continue;
                allOrders.add(new SortField(property, type == null ? SortField.Type.SCORE : type, reverse == null ? false : reverse));
            }
        }
        return allOrders.isEmpty() ? null : new LuceneSort(new Sort(allOrders.toArray(new SortField[allOrders.size()])));
    }

    private SortField.Type getType(String element) {
        try {
            return SortField.Type.valueOf((String)element);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

