/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.mapping;

import cn.bestwu.framework.rest.support.Version;
import cn.bestwu.framework.rest.support.VersionedSerializationView;
import cn.bestwu.framework.util.ResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SerializationViewMappings {
    private final Class<?> serializationViewsClass;
    private final Map<String, List<VersionedSerializationView>> cache = new HashMap<String, List<VersionedSerializationView>>();

    public SerializationViewMappings(Class<?> serializationViewsClass) {
        this.serializationViewsClass = serializationViewsClass;
        this.populateCache();
    }

    private void populateCache() {
        if (this.serializationViewsClass == null) {
            return;
        }
        Class<?>[] classes = this.serializationViewsClass.getClasses();
        for (Class<?> clazz : classes) {
            boolean firstPut;
            String className = clazz.getSimpleName();
            String signature = className.replaceAll("^(.*)_v_.*$", "$1");
            String version = className.replaceAll("^.*_v_(.*)$", "$1");
            version = version.equals(signature) ? Version.DEFAULT_VERSION : version.replace("_", ".");
            List<VersionedSerializationView> jsonViews = this.cache.get(signature);
            boolean bl = firstPut = jsonViews == null;
            if (firstPut) {
                jsonViews = new ArrayList<VersionedSerializationView>();
            }
            jsonViews.add(new VersionedSerializationView(version, clazz));
            if (!firstPut) continue;
            this.cache.put(signature, jsonViews);
        }
        for (List list : this.cache.values()) {
            Collections.sort(list);
        }
    }

    public Class<?> getSerializationView() {
        if (this.serializationViewsClass == null) {
            return null;
        }
        String requestSignature = ResourceUtil.API_SIGNATURE.get();
        if (requestSignature == null) {
            return null;
        }
        List<VersionedSerializationView> jsonViews = this.cache.get(requestSignature);
        if (jsonViews == null || jsonViews.isEmpty()) {
            return null;
        }
        String requestVersion = ResourceUtil.REQUEST_VERSION.get();
        for (VersionedSerializationView jsonView : jsonViews) {
            if (!Version.equals(jsonView.getVersion(), requestVersion)) continue;
            return jsonView.getSerializationView();
        }
        for (VersionedSerializationView jsonView : jsonViews) {
            String version = jsonView.getVersion();
            if (!version.contains(requestVersion) && !version.matches(requestVersion)) continue;
            return jsonView.getSerializationView();
        }
        return jsonViews.get(0).getSerializationView();
    }
}

