/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.filter;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OrderedHiddenHttpMethodFilter
extends OncePerRequestFilter
implements Ordered {
    public static final int DEFAULT_ORDER = -10000;
    private int order = -10000;
    public static final String DEFAULT_METHOD_PARAM = "_method";
    private String methodParam = "_method";

    public void setMethodParam(String methodParam) {
        Assert.hasText((String)methodParam, (String)"'methodParam' must not be empty");
        this.methodParam = methodParam;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String paramValue = request.getParameter(this.methodParam);
        if (StringUtils.hasLength((String)paramValue)) {
            String _method = request.getMethod();
            String method = paramValue.toUpperCase(Locale.ENGLISH);
            if ("POST".equals(_method) && "PUT".equals(method) || "GET".equals(_method) && "DELETE".equals(method)) {
                HttpMethodRequestWrapper wrapper = new HttpMethodRequestWrapper(request, method);
                filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)response);
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private static class HttpMethodRequestWrapper
    extends HttpServletRequestWrapper {
        private final String method;

        public HttpMethodRequestWrapper(HttpServletRequest request, String method) {
            super(request);
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

