/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.controller;

import cn.bestwu.framework.rest.support.Response;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.AbstractErrorController;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@ConditionalOnWebApplication
@RequestMapping(value={"${server.error.path:${error.path:/error}}"})
public class CustomErrorController
extends AbstractErrorController {
    @Autowired
    private ServerProperties serverProperties;
    @Autowired
    private MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter;

    @Autowired
    public CustomErrorController(ErrorAttributes errorAttributes) {
        super(errorAttributes);
    }

    public String getErrorPath() {
        return this.serverProperties.getError().getPath();
    }

    private String getString(Map<String, Object> body) throws JsonProcessingException {
        return this.mappingJackson2HttpMessageConverter.getObjectMapper().writeValueAsString(body);
    }

    protected ErrorProperties getErrorProperties() {
        return this.serverProperties.getError();
    }

    protected boolean isIncludeStackTrace(HttpServletRequest request, MediaType ... produces) {
        ErrorProperties.IncludeStacktrace include = this.getErrorProperties().getIncludeStacktrace();
        if (include == ErrorProperties.IncludeStacktrace.ALWAYS) {
            return true;
        }
        if (include == ErrorProperties.IncludeStacktrace.ON_TRACE_PARAM) {
            return this.getTraceParameter(request);
        }
        return false;
    }

    @RequestMapping(produces={"text/plain", "text/html"})
    @ResponseBody
    public ResponseEntity<String> errorPlain(HttpServletRequest request) throws JsonProcessingException {
        Map body = this.getErrorAttributes(request, this.isIncludeStackTrace(request, MediaType.TEXT_HTML, MediaType.TEXT_PLAIN));
        HttpStatus status = this.getStatus(request);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)status).headers(Response.noCache())).body((Object)this.getString(body));
    }

    @RequestMapping
    @ResponseBody
    public ResponseEntity<?> error(HttpServletRequest request) throws JsonProcessingException {
        Map body = this.getErrorAttributes(request, this.isIncludeStackTrace(request, MediaType.ALL));
        HttpStatus status = this.getStatus(request);
        if (status.equals((Object)HttpStatus.NOT_ACCEPTABLE)) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)status).headers(Response.noCache())).body((Object)this.getString(body));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)status).headers(Response.noCache())).body((Object)body);
    }
}

