/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.lang.util.keyword.filter;

import cn.bestwu.lang.util.keyword.CharNode;
import cn.bestwu.lang.util.keyword.MatchType;
import cn.bestwu.lang.util.keyword.filter.KeywordFilter;
import cn.bestwu.lang.util.keyword.replace.DefaultReplaceStrategy;
import cn.bestwu.lang.util.keyword.replace.ReplaceStrategy;
import java.util.Arrays;
import java.util.Collection;

public class SimpleKeywordFilter
implements KeywordFilter {
    protected final CharNode root = new CharNode();
    protected MatchType matchType = MatchType.LONG;
    protected ReplaceStrategy strategy = new DefaultReplaceStrategy();

    @Override
    public String replace(String text) {
        CharNode last = this.root;
        StringBuilder result = new StringBuilder();
        char[] words = text.toCharArray();
        boolean matchShort = this.matchType.equals((Object)MatchType.SHORT);
        for (int i = 0; i < words.length; ++i) {
            char word = words[i];
            int length = last.getLength();
            int lastIndex = i - length;
            boolean end = i == words.length - 1;
            boolean containLast = false;
            CharNode charNode = last.get(word);
            if (charNode != null) {
                last = charNode;
                ++length;
                containLast = true;
            }
            boolean lastEnd = last.isEnd();
            if (last == this.root) {
                result.append(word);
                continue;
            }
            if (containLast && matchShort && lastEnd) {
                result.append(this.strategy.replaceWith(Arrays.copyOfRange(words, lastIndex, lastIndex + length)));
                last = this.root;
                continue;
            }
            if (containLast && !end) continue;
            if (lastEnd) {
                result.append(this.strategy.replaceWith(Arrays.copyOfRange(words, lastIndex, lastIndex + length)));
                if (!containLast) {
                    --i;
                }
            } else if (matchShort) {
                i = lastIndex;
                result.append(words[i]);
            } else {
                CharNode failNode = last.getFailNode();
                if (failNode == this.root) {
                    i = lastIndex;
                    result.append(words[i]);
                } else {
                    int failLength = failNode.getLength();
                    i = lastIndex + failLength - 1;
                    result.append(this.strategy.replaceWith(Arrays.copyOfRange(words, lastIndex, lastIndex + failLength)));
                }
            }
            last = this.root;
        }
        return result.toString();
    }

    @Override
    public void compile(Collection<String> keywords) {
        this.addKeywords(keywords);
        this.buildFailNode(this.root);
    }

    protected void addKeywords(Collection<String> keywords) {
        for (String keyword : keywords) {
            if (null == keyword || keyword.trim().isEmpty()) {
                throw new IllegalArgumentException("\u8fc7\u6ee4\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            char[] charArray = keyword.toCharArray();
            CharNode node = this.root;
            for (char aCharArray : charArray) {
                node = node.addChild(Character.valueOf(aCharArray));
            }
            node.addChild(null);
        }
    }

    protected void buildFailNode(CharNode node) {
        this.doFailNode(node);
        Collection<CharNode> childNodes = node.childNodes();
        for (CharNode childNode : childNodes) {
            this.buildFailNode(childNode);
        }
    }

    private void doFailNode(CharNode node) {
        CharNode parent;
        if (node == this.root) {
            return;
        }
        for (parent = node.getParent(); !parent.isEnd() && parent != this.root; parent = parent.getParent()) {
        }
        node.setFailNode(parent);
    }

    public void setMatchType(MatchType matchType) {
        this.matchType = matchType;
    }

    public void setStrategy(ReplaceStrategy strategy) {
        this.strategy = strategy;
    }
}

