/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.lang.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtil {
    private static Logger log = LoggerFactory.getLogger(StringUtil.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasText(CharSequence str) {
        if (!StringUtil.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String addUnderscores(String s) {
        StringBuilder buf = new StringBuilder(s.replace('.', '_'));
        for (int i = 1; i < buf.length() - 1; ++i) {
            if (!Character.isLowerCase(buf.charAt(i - 1)) || !Character.isUpperCase(buf.charAt(i)) || !Character.isLowerCase(buf.charAt(i + 1))) continue;
            buf.insert(i++, '_');
        }
        return buf.toString().toLowerCase(Locale.ROOT);
    }

    public static String valueOf(Object object) {
        return StringUtil.valueOf(object, false);
    }

    public static String valueOf(Object object, boolean format) {
        if (object == null) {
            return "null";
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            int length = Array.getLength(object);
            int iMax = length - 1;
            if (iMax == -1) {
                return "[]";
            }
            StringBuilder b = new StringBuilder();
            b.append('[');
            int i = 0;
            while (true) {
                b.append(StringUtil.valueOf(Array.get(object, i), format));
                if (i == iMax) {
                    return b.append(']').toString();
                }
                b.append(", ");
                ++i;
            }
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            Enumeration es = (Enumeration)object;
            if (!es.hasMoreElements()) {
                return "[]";
            }
            StringBuilder b = new StringBuilder();
            b.append('[');
            while (es.hasMoreElements()) {
                Object e = es.nextElement();
                b.append(StringUtil.valueOf(e, format));
                if (!es.hasMoreElements()) {
                    return b.append(']').toString();
                }
                b.append(", ");
            }
        } else {
            try {
                String string;
                if (format) {
                    objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
                }
                if ((string = null) == null) {
                    string = objectMapper.writeValueAsString(object);
                }
                if (format) {
                    objectMapper.disable(SerializationFeature.INDENT_OUTPUT);
                }
                return string;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return String.valueOf(object);
    }

    public static String subString(String str, int length) {
        if (str == null) {
            return null;
        }
        int l = str.length();
        if (l > length) {
            return str.substring(0, length);
        }
        return str;
    }

    public static String subStringWithEllipsis(String str, int length) {
        if (str == null) {
            return null;
        }
        int l = str.length();
        if (l > length) {
            return str.substring(0, length - 3) + "...";
        }
        return str;
    }

    public static int countSubString(String str, String sub) {
        if (str.contains(sub)) {
            return StringUtil.splitWorker(str, sub, -1, false).length - 1;
        }
        return 0;
    }

    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String compress(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DeflaterOutputStream gzip = new DeflaterOutputStream(out);
            gzip.write(str.getBytes());
            gzip.close();
            return new String(out.toByteArray(), "ISO-8859-1");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decompress(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(str.getBytes("ISO-8859-1"));
            InflaterInputStream zipInputStream = new InflaterInputStream(byteArrayInputStream);
            return StringUtil.copyToString(zipInputStream, Charset.forName("ISO-8859-1"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String copyToString(InputStream in, Charset charset) throws IOException {
        int bytesRead;
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in, charset);
        char[] buffer = new char[4096];
        while ((bytesRead = reader.read(buffer)) != -1) {
            out.append(buffer, 0, bytesRead);
        }
        return out.toString();
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_INDEX);
        objectMapper.disable(SerializationFeature.WRITE_NULL_MAP_VALUES, new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS});
        objectMapper.disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
    }
}

