/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.lang.util;

import java.util.Random;

public class RandomUtil {
    private static final Random RANDOM = new Random();

    public static String nextIntString(int num) {
        return RandomUtil.nextString(num, "0123456789");
    }

    public static String nextString(int count, String chars) {
        if (chars == null) {
            return RandomUtil.next(count, 0, 0, false, false, null, RANDOM);
        }
        return RandomUtil.nextString(count, chars.toCharArray());
    }

    public static String nextString(int count, char[] chars) {
        if (chars == null) {
            return RandomUtil.next(count, 0, 0, false, false, null, RANDOM);
        }
        return RandomUtil.next(count, 0, chars.length, false, false, chars, RANDOM);
    }

    public static String next(int count, int start, int end, boolean letters, boolean numbers, char[] chars, Random random) {
        if (count == 0) {
            return "";
        }
        if (count < 0) {
            throw new IllegalArgumentException("Requested next string length " + count + " is less than 0.");
        }
        if (start == 0 && end == 0) {
            end = 123;
            start = 32;
            if (!letters && !numbers) {
                start = 0;
                end = Integer.MAX_VALUE;
            }
        }
        char[] buffer = new char[count];
        int gap = end - start;
        while (count-- != 0) {
            char ch = chars == null ? (char)(random.nextInt(gap) + start) : chars[random.nextInt(gap) + start];
            if (letters && Character.isLetter(ch) || numbers && Character.isDigit(ch) || !letters && !numbers) {
                if (ch >= '\udc00' && ch <= '\udfff') {
                    if (count == 0) {
                        ++count;
                        continue;
                    }
                    buffer[count] = ch;
                    buffer[--count] = (char)(55296 + random.nextInt(128));
                    continue;
                }
                if (ch >= '\ud800' && ch <= '\udb7f') {
                    if (count == 0) {
                        ++count;
                        continue;
                    }
                    buffer[count] = (char)(56320 + random.nextInt(128));
                    buffer[--count] = ch;
                    continue;
                }
                if (ch >= '\udb80' && ch <= '\udbff') {
                    ++count;
                    continue;
                }
                buffer[count] = ch;
                continue;
            }
            ++count;
        }
        return new String(buffer);
    }

    public static int nextInt(int num) {
        return Integer.parseInt(RandomUtil.nextIntString(num));
    }

    public static String nextString(int num) {
        return RandomUtil.nextString(num, "abcdefghigklmnopqrstuvwxyz");
    }

    public static String nextString2(int num) {
        return RandomUtil.nextString(num, "abcdefghigklmnopqrstuvwxyzABCDEFGHIGKLMNOPQRSTUVWXYZ0123456789");
    }
}

