/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.lang.util;

public class CellUtil {
    private static final String CHINA_MOBILE_CELL_REGEX = "^(134\\d|135\\d|136\\d|137\\d|138\\d|139\\d|150\\d|151\\d|152\\d|157\\d|158\\d|159\\d|182\\d|183\\d|184\\d|187\\d|178\\d|188\\d|147\\d|1705)\\d{7}$";
    private static final String CHINA_UNICOM_CELL_REGEX = "^(130\\d|131\\d|132\\d|155\\d|156\\d|176\\d|185\\d|186\\d|1709)\\d{7}$";
    private static final String CHINA_TELECOM_CELL_REGEX = "^(133\\d|153\\d|173\\d|177\\d|180\\d|181\\d|189\\d|1700)\\d{7}$";
    private static final String CHINA_VNO_CELL_REGEX = "^(170|171)\\d{8}$";

    public static boolean isChinaMobile(String cell) {
        if (cell == null) {
            return false;
        }
        return cell.matches(CHINA_MOBILE_CELL_REGEX);
    }

    public static boolean isChinaUnicom(String cell) {
        if (cell == null) {
            return false;
        }
        return cell.matches(CHINA_UNICOM_CELL_REGEX);
    }

    public static boolean isChinaTelecom(String cell) {
        if (cell == null) {
            return false;
        }
        return cell.matches(CHINA_TELECOM_CELL_REGEX);
    }

    public static boolean isChinaVNO(String cell) {
        if (cell == null) {
            return false;
        }
        return cell.matches(CHINA_VNO_CELL_REGEX);
    }

    public static boolean isChinaCell(String cell) {
        if (cell == null) {
            return false;
        }
        return CellUtil.isChinaMobile(cell) || CellUtil.isChinaUnicom(cell) || CellUtil.isChinaTelecom(cell) || CellUtil.isChinaVNO(cell);
    }
}

