/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.api.sign;

import cn.bestwu.api.sign.ApiSignAlgorithm;
import cn.bestwu.api.sign.ApiSignHandlerInterceptor;
import cn.bestwu.api.sign.ApiSignProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnWebApplication
@Conditional(value={ApiSignCondition.class})
@EnableConfigurationProperties(value={ApiSignProperties.class})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0003\u001a\u00020\u0004H\u0017R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcn/bestwu/api/sign/ApiSignConfiguration;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "()V", "apiSignAlgorithm", "Lcn/bestwu/api/sign/ApiSignAlgorithm;", "getApiSignAlgorithm", "()Lcn/bestwu/api/sign/ApiSignAlgorithm;", "setApiSignAlgorithm", "(Lcn/bestwu/api/sign/ApiSignAlgorithm;)V", "properties", "Lcn/bestwu/api/sign/ApiSignProperties;", "getProperties", "()Lcn/bestwu/api/sign/ApiSignProperties;", "setProperties", "(Lcn/bestwu/api/sign/ApiSignProperties;)V", "addInterceptors", "", "registry", "Lorg/springframework/web/servlet/config/annotation/InterceptorRegistry;", "ApiSignCondition", "api-sign"})
public class ApiSignConfiguration
implements WebMvcConfigurer {
    @Autowired
    @NotNull
    public ApiSignProperties properties;
    @Autowired
    @NotNull
    public ApiSignAlgorithm apiSignAlgorithm;

    @NotNull
    public ApiSignProperties getProperties() {
        ApiSignProperties apiSignProperties = this.properties;
        if (apiSignProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
        }
        return apiSignProperties;
    }

    public void setProperties(@NotNull ApiSignProperties apiSignProperties) {
        Intrinsics.checkParameterIsNotNull((Object)apiSignProperties, (String)"<set-?>");
        this.properties = apiSignProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={ApiSignAlgorithm.class})
    @NotNull
    public ApiSignAlgorithm apiSignAlgorithm() {
        return new ApiSignAlgorithm(this.getProperties());
    }

    @NotNull
    public ApiSignAlgorithm getApiSignAlgorithm() {
        ApiSignAlgorithm apiSignAlgorithm = this.apiSignAlgorithm;
        if (apiSignAlgorithm == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apiSignAlgorithm");
        }
        return apiSignAlgorithm;
    }

    public void setApiSignAlgorithm(@NotNull ApiSignAlgorithm apiSignAlgorithm) {
        Intrinsics.checkParameterIsNotNull((Object)apiSignAlgorithm, (String)"<set-?>");
        this.apiSignAlgorithm = apiSignAlgorithm;
    }

    public void addInterceptors(@NotNull InterceptorRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        ApiSignAlgorithm apiSignAlgorithm = this.getApiSignAlgorithm();
        String[] stringArray = this.getProperties().getHandlerTypePrefix();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"properties.handlerTypePrefix");
        registry.addInterceptor((HandlerInterceptor)new ApiSignHandlerInterceptor(apiSignAlgorithm, stringArray));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcn/bestwu/api/sign/ApiSignConfiguration$ApiSignCondition;", "Lorg/springframework/context/annotation/Condition;", "()V", "matches", "", "context", "Lorg/springframework/context/annotation/ConditionContext;", "metadata", "Lorg/springframework/core/type/AnnotatedTypeMetadata;", "api-sign"})
    public static final class ApiSignCondition
    implements Condition {
        public boolean matches(@NotNull ConditionContext context, @NotNull AnnotatedTypeMetadata metadata) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)metadata, (String)"metadata");
            return !(!StringUtils.hasText((String)context.getEnvironment().getProperty("api.sign.client-secret")) && !StringUtils.hasText((String)context.getEnvironment().getProperty("api.sign.clientSecret")) || !StringUtils.hasText((String)context.getEnvironment().getProperty("api.sign.handler-type-prefix")) && !StringUtils.hasText((String)context.getEnvironment().getProperty("api.sign.handlerTypePrefix")));
        }
    }
}

