/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.api.sign;

import cn.bestwu.api.sign.ApiSignAlgorithm;
import cn.bestwu.api.sign.IllegalSignException;
import java.lang.reflect.AnnotatedElement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u0010\u0019\u001a\u00020\u0010*\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcn/bestwu/api/sign/ApiSignHandlerInterceptor;", "Lorg/springframework/web/servlet/handler/HandlerInterceptorAdapter;", "Lorg/springframework/context/MessageSourceAware;", "Lorg/springframework/core/Ordered;", "apiSignAlgorithm", "Lcn/bestwu/api/sign/ApiSignAlgorithm;", "handlerTypePrefix", "", "", "(Lcn/bestwu/api/sign/ApiSignAlgorithm;[Ljava/lang/String;)V", "[Ljava/lang/String;", "messageSource", "Lorg/springframework/context/MessageSource;", "getOrder", "", "preHandle", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "handler", "", "setMessageSource", "", "packageMatches", "regex", "api-sign"})
public final class ApiSignHandlerInterceptor
extends HandlerInterceptorAdapter
implements MessageSourceAware,
Ordered {
    private MessageSource messageSource;
    private ApiSignAlgorithm apiSignAlgorithm;
    private final String[] handlerTypePrefix;

    public void setMessageSource(@Nullable MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public int getOrder() {
        return -2147483628;
    }

    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        if (handler instanceof HandlerMethod && !(((HandlerMethod)handler).getBean() instanceof ErrorController)) {
            boolean bl;
            block11: {
                for (Object element$iv : (Object[])this.handlerTypePrefix) {
                    String it = (String)element$iv;
                    Class clazz = ((HandlerMethod)handler).getBeanType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"handler.beanType");
                    String string = clazz.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"handler.beanType.name");
                    if (!this.packageMatches(string, it)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
            if (bl) {
                try {
                    this.apiSignAlgorithm.checkSign(request);
                }
                catch (IllegalSignException e) {
                    ResponseStatus responseStatus = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)e.getClass(), ResponseStatus.class);
                    if (responseStatus != null) {
                        int statusCode = responseStatus.code().value();
                        String reason = responseStatus.reason();
                        if (!StringUtils.hasLength((String)reason)) {
                            response.sendError(statusCode);
                        } else {
                            String string;
                            if (this.messageSource != null) {
                                MessageSource messageSource = this.messageSource;
                                if (messageSource == null) {
                                    Intrinsics.throwNpe();
                                }
                                string = messageSource.getMessage(reason, null, reason, LocaleContextHolder.getLocale());
                            } else {
                                string = reason;
                            }
                            String resolvedReason = string;
                            response.sendError(statusCode, resolvedReason);
                        }
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private final boolean packageMatches(@NotNull String $receiver, String regex) {
        CharSequence charSequence = $receiver;
        Regex regex2 = new Regex("^" + StringsKt.replace$default((String)StringsKt.replace$default((String)regex, (String)".", (String)"\\.", (boolean)false, (int)4, null), (String)"*", (String)".+", (boolean)false, (int)4, null) + ".*$");
        return regex2.matches(charSequence);
    }

    public ApiSignHandlerInterceptor(@NotNull ApiSignAlgorithm apiSignAlgorithm, @NotNull String[] handlerTypePrefix) {
        Intrinsics.checkParameterIsNotNull((Object)apiSignAlgorithm, (String)"apiSignAlgorithm");
        Intrinsics.checkParameterIsNotNull((Object)handlerTypePrefix, (String)"handlerTypePrefix");
        this.apiSignAlgorithm = apiSignAlgorithm;
        this.handlerTypePrefix = handlerTypePrefix;
    }
}

