/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.api.sign;

import cn.bestwu.api.sign.ApiSignProperties;
import cn.bestwu.api.sign.IllegalSignException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\fJ\"\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u000e\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\fH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcn/bestwu/api/sign/ApiSignAlgorithm;", "", "properties", "Lcn/bestwu/api/sign/ApiSignProperties;", "(Lcn/bestwu/api/sign/ApiSignProperties;)V", "checkSign", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "sign", "", "requestParams", "Lorg/springframework/util/MultiValueMap;", "userAgent", "signParams", "signTime", "time", "", "signUserAgent", "skip", "", "Companion", "api-sign"})
public final class ApiSignAlgorithm {
    private final ApiSignProperties properties;
    private static final Logger log;
    public static final Companion Companion;

    public final void checkSign(@NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        String signParameter = this.properties.getParameterName();
        String sign = request.getHeader(signParameter);
        if (sign == null) {
            sign = request.getParameter(signParameter);
        }
        if (this.skip(request)) {
            return;
        }
        if (!StringUtils.hasText((String)sign)) {
            Logger logger = ApiSignAlgorithm.Companion.getLog();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
            if (logger.isDebugEnabled()) {
                ApiSignAlgorithm.Companion.getLog().debug("\u5ba2\u6237\u7aef\u7b7e\u540d\u4e3a\u7a7a");
            }
            throw (Throwable)new IllegalSignException();
        }
        String string = sign;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        if (string.length() != 32) {
            Logger logger = ApiSignAlgorithm.Companion.getLog();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
            if (logger.isDebugEnabled()) {
                ApiSignAlgorithm.Companion.getLog().debug("\u5ba2\u6237\u7aef\u7b7e\u540d\u957f\u5ea6\u4e0d\u5339\u914d{}\uff1a{}", (Object)sign.length(), (Object)sign);
            }
            throw (Throwable)new IllegalSignException();
        }
        if (this.properties.isSimple()) {
            String signParams = this.signParams(request);
            if (!StringsKt.equals((String)sign, (String)signParams, (boolean)true)) {
                Logger logger = ApiSignAlgorithm.Companion.getLog();
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
                if (logger.isDebugEnabled()) {
                    String string2 = sign;
                    int n = 0;
                    int n2 = 16;
                    String string3 = "\u5ba2\u6237\u7aef\u53c2\u6570\u7b7e\u540d\u9519\u8bef,\u5ba2\u6237\u7aef\uff1a{}\uff0c\u670d\u52a1\u7aef\uff1a{}";
                    Logger logger2 = ApiSignAlgorithm.Companion.getLog();
                    String string4 = string2.substring(n, n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string5 = string4;
                    logger2.debug(string3, (Object)string5, (Object)signParams);
                }
                throw (Throwable)new IllegalSignException();
            }
        } else {
            int clientTimeDifference;
            int n;
            String string6 = this.signParams(request);
            int n3 = 0;
            int n4 = 16;
            String string7 = string6;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(n3, n4);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String signParams = string8;
            string6 = sign;
            n3 = 0;
            n4 = 16;
            String string9 = string6.substring(n3, n4);
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (!StringsKt.equals((String)string9, (String)signParams, (boolean)true)) {
                Logger logger = ApiSignAlgorithm.Companion.getLog();
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
                if (logger.isDebugEnabled()) {
                    string6 = sign;
                    n3 = 0;
                    n4 = 16;
                    String string10 = "\u5ba2\u6237\u7aef\u53c2\u6570\u7b7e\u540d\u9519\u8bef,\u5ba2\u6237\u7aef\uff1a{}\uff0c\u670d\u52a1\u7aef\uff1a{}";
                    Logger logger3 = ApiSignAlgorithm.Companion.getLog();
                    String string11 = string6.substring(n3, n4);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string12 = string11;
                    logger3.debug(string10, (Object)string12, (Object)signParams);
                }
                throw (Throwable)new IllegalSignException();
            }
            if (this.properties.isVerifyUserAgent()) {
                String string13 = request.getHeader("user-agent");
                Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"request.getHeader(\"user-agent\")");
                String string14 = this.signUserAgent(string13);
                n4 = 16;
                n = 24;
                String string15 = string14;
                if (string15 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string16 = string15.substring(n4, n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string16, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String signUserAgent = string16;
                string14 = sign;
                n4 = 16;
                n = 24;
                String string17 = string14.substring(n4, n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string17, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                if (!StringsKt.equals((String)string17, (String)signUserAgent, (boolean)true)) {
                    Logger logger = ApiSignAlgorithm.Companion.getLog();
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
                    if (logger.isDebugEnabled()) {
                        string14 = sign;
                        n4 = 16;
                        n = 24;
                        String string18 = "\u5ba2\u6237\u7aefUserAgent\u7b7e\u540d\u9519\u8bef,\u5ba2\u6237\u7aef\uff1a{}\uff0c\u670d\u52a1\u7aef\uff1a{}";
                        Logger logger4 = ApiSignAlgorithm.Companion.getLog();
                        String string19 = string14.substring(n4, n);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string19, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string20 = string19;
                        logger4.debug(string18, (Object)string20, (Object)signUserAgent);
                    }
                    throw (Throwable)new IllegalSignException();
                }
            }
            if ((clientTimeDifference = this.properties.getAllowableClientTimeDifference()) > 0) {
                String string21 = sign;
                n = 24;
                int n5 = 32;
                String string22 = string21.substring(n, n5);
                Intrinsics.checkExpressionValueIsNotNull((Object)string22, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String signTime = string22;
                long time = System.currentTimeMillis() / (long)(clientTimeDifference * 1000);
                String string23 = this.signTime(time);
                int n6 = 24;
                int n7 = 32;
                String string24 = string23;
                if (string24 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string25 = string24.substring(n6, n7);
                Intrinsics.checkExpressionValueIsNotNull((Object)string25, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                if (!StringsKt.equals((String)string25, (String)signTime, (boolean)true)) {
                    string23 = this.signTime(time - 1L);
                    n6 = 24;
                    n7 = 32;
                    String string26 = string23;
                    if (string26 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string27 = string26.substring(n6, n7);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string27, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    if (!StringsKt.equals((String)string27, (String)signTime, (boolean)true)) {
                        string23 = this.signTime(time + 1L);
                        n6 = 24;
                        n7 = 32;
                        String string28 = string23;
                        if (string28 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string29 = string28.substring(n6, n7);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string29, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        if (!StringsKt.equals((String)string29, (String)signTime, (boolean)true)) {
                            Logger logger = ApiSignAlgorithm.Companion.getLog();
                            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
                            if (logger.isDebugEnabled()) {
                                string23 = sign;
                                n6 = 24;
                                n7 = 32;
                                String string30 = "\u5ba2\u6237\u7aef\u65f6\u95f4\u7b7e\u540d\u9519\u8bef,\u5ba2\u6237\u7aef\uff1a{}";
                                Logger logger5 = ApiSignAlgorithm.Companion.getLog();
                                String string31 = string23.substring(n6, n7);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string31, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                String string32 = string31;
                                logger5.debug(string30, (Object)string32);
                            }
                            throw (Throwable)new IllegalSignException();
                        }
                    }
                }
            }
        }
        Logger logger = ApiSignAlgorithm.Companion.getLog();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        if (logger.isDebugEnabled()) {
            ApiSignAlgorithm.Companion.getLog().debug("\u7b7e\u540d\u9a8c\u8bc1\u901a\u8fc7");
        }
    }

    @NotNull
    public final String sign(@NotNull MultiValueMap<String, String> requestParams, @NotNull String userAgent) {
        String string;
        Intrinsics.checkParameterIsNotNull(requestParams, (String)"requestParams");
        Intrinsics.checkParameterIsNotNull((Object)userAgent, (String)"userAgent");
        if (this.properties.isSimple()) {
            string = this.signParams(requestParams);
        } else {
            String string2 = this.signParams(requestParams);
            int n = 0;
            int n2 = 16;
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = string4;
            string2 = this.signUserAgent(userAgent);
            n = 16;
            n2 = 24;
            stringBuilder = stringBuilder.append(string5);
            String string6 = string2;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string5 = string7;
            string2 = this.signTime(System.currentTimeMillis() / (long)this.properties.getAllowableClientTimeDifference());
            n = 24;
            n2 = 32;
            stringBuilder = stringBuilder.append(string5);
            String string8 = string2;
            if (string8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string5 = string9;
            string = stringBuilder.append(string5).toString();
        }
        return string;
    }

    @NotNull
    public final String sign(@NotNull MultiValueMap<String, String> requestParams) {
        String string;
        Intrinsics.checkParameterIsNotNull(requestParams, (String)"requestParams");
        if (this.properties.isSimple()) {
            string = this.signParams(requestParams);
        } else {
            String string2 = this.signParams(requestParams);
            int n = 0;
            int n2 = 16;
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = string4;
            string2 = this.signUserAgent("");
            n = 16;
            n2 = 24;
            stringBuilder = stringBuilder.append(string5);
            String string6 = string2;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string5 = string7;
            string2 = this.signTime(System.currentTimeMillis() / (long)this.properties.getAllowableClientTimeDifference());
            n = 24;
            n2 = 32;
            stringBuilder = stringBuilder.append(string5);
            String string8 = string2;
            if (string8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string5 = string9;
            string = stringBuilder.append(string5).toString();
        }
        return string;
    }

    private final String signTime(long time) {
        String timestamp = String.valueOf(time);
        String string = timestamp = timestamp + this.properties.getClientSecret();
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string3 = DigestUtils.md5DigestAsHex((byte[])byArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"DigestUtils.md5DigestAsH\u2026(timestamp.toByteArray())");
        timestamp = string3;
        return timestamp;
    }

    private final String signUserAgent(String userAgent) {
        String useragent = userAgent;
        String string = useragent = useragent + this.properties.getClientSecret();
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string3 = DigestUtils.md5DigestAsHex((byte[])byArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"DigestUtils.md5DigestAsH\u2026(useragent.toByteArray())");
        useragent = string3;
        return useragent;
    }

    /*
     * WARNING - void declaration
     */
    private final String signParams(HttpServletRequest request) {
        Map requestParams = request.getParameterMap();
        ArrayList keys = new ArrayList(requestParams.keySet());
        Collections.sort(keys);
        StringBuilder prestr = new StringBuilder("");
        for (String key : keys) {
            String[] values = (String[])requestParams.get(key);
            StringBuilder value = new StringBuilder();
            if (values == null) {
                Intrinsics.throwNpe();
            }
            int length = ((Object[])values).length;
            int n = 0;
            int n2 = length;
            while (n < n2) {
                void i;
                value.append(values[i]);
                value.append(i == length - 1 ? "" : ",");
                ++i;
            }
            if (Intrinsics.areEqual((Object)value.toString(), (Object)"") || StringsKt.equals((String)key, (String)"sign", (boolean)true) || StringsKt.equals((String)key, (String)"sign_type", (boolean)true)) continue;
            prestr.append(key).append("=").append((CharSequence)value).append("&");
        }
        Logger logger = ApiSignAlgorithm.Companion.getLog();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        if (logger.isDebugEnabled()) {
            ApiSignAlgorithm.Companion.getLog().debug("\u5f85\u7b7e\u540d\u53c2\u6570\u5b57\u7b26\u4e32\uff1a{}", (Object)prestr);
        }
        StringBuilder stringBuilder = prestr.append(this.properties.getClientSecret());
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"prestr.append(properties.clientSecret)");
        prestr = stringBuilder;
        String string = prestr.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"prestr.toString()");
        String string2 = string;
        Charset charset = Charsets.UTF_8;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string4 = DigestUtils.md5DigestAsHex((byte[])byArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"DigestUtils.md5DigestAsH\u2026toString().toByteArray())");
        return string4;
    }

    /*
     * WARNING - void declaration
     */
    private final String signParams(MultiValueMap<String, String> requestParams) {
        ArrayList keys = new ArrayList(requestParams.keySet());
        Collections.sort(keys);
        StringBuilder prestr = new StringBuilder("");
        for (String key : keys) {
            List values = (List)requestParams.get((Object)key);
            StringBuilder value = new StringBuilder();
            List list = values;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            int length = list.size();
            int n = 0;
            int n2 = length;
            while (n < n2) {
                void i;
                value.append((String)values.get((int)i));
                value.append(i == length - 1 ? "" : ",");
                ++i;
            }
            if (Intrinsics.areEqual((Object)value.toString(), (Object)"") || StringsKt.equals((String)key, (String)"sign", (boolean)true) || StringsKt.equals((String)key, (String)"sign_type", (boolean)true)) continue;
            prestr.append(key).append("=").append((CharSequence)value).append("&");
        }
        Logger logger = ApiSignAlgorithm.Companion.getLog();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        if (logger.isDebugEnabled()) {
            ApiSignAlgorithm.Companion.getLog().debug("\u5f85\u7b7e\u540d\u53c2\u6570\u5b57\u7b26\u4e32\uff1a{}", (Object)prestr);
        }
        StringBuilder stringBuilder = prestr.append(this.properties.getClientSecret());
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"prestr.append(properties.clientSecret)");
        prestr = stringBuilder;
        String string = prestr.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"prestr.toString()");
        String string2 = string;
        Charset charset = Charsets.UTF_8;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string4 = DigestUtils.md5DigestAsHex((byte[])byArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"DigestUtils.md5DigestAsH\u2026toString().toByteArray())");
        return string4;
    }

    private final boolean skip(HttpServletRequest request) {
        boolean bl;
        if (this.properties.isCanSkip()) {
            Object object = request.getAttribute("SKIP_SIGN");
            if (!(object instanceof Boolean)) {
                object = null;
            }
            Boolean bl2 = (Boolean)object;
            bl = bl2 != null ? bl2 : false;
        } else {
            bl = false;
        }
        return bl;
    }

    public ApiSignAlgorithm(@NotNull ApiSignProperties properties) {
        Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
        this.properties = properties;
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(ApiSignAlgorithm.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rR\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcn/bestwu/api/sign/ApiSignAlgorithm$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "request", "Ljavax/servlet/http/HttpServletRequest;", "getRequest", "()Ljavax/servlet/http/HttpServletRequest;", "skip", "", "api-sign"})
    public static final class Companion {
        private final Logger getLog() {
            return log;
        }

        public final void skip() {
            HttpServletRequest httpServletRequest = this.getRequest();
            if (httpServletRequest == null) {
                Intrinsics.throwNpe();
            }
            httpServletRequest.setAttribute("SKIP_SIGN", (Object)true);
        }

        private final HttpServletRequest getRequest() {
            ServletRequestAttributes requestAttributes;
            RequestAttributes requestAttributes2 = RequestContextHolder.getRequestAttributes();
            if (!(requestAttributes2 instanceof ServletRequestAttributes)) {
                requestAttributes2 = null;
            }
            ServletRequestAttributes servletRequestAttributes = requestAttributes = (ServletRequestAttributes)requestAttributes2;
            return servletRequestAttributes != null ? servletRequestAttributes.getRequest() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

