/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.api.sign;

import cn.bestwu.api.sign.ApiSignProperties;
import cn.bestwu.api.sign.InvalidRequestException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\fJ\"\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\nJ\b\u0010\u000e\u001a\u00020\nH\u0002J\u001c\u0010\u000e\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\fH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcn/bestwu/api/sign/ApiSignAlgorithm;", "", "properties", "Lcn/bestwu/api/sign/ApiSignProperties;", "(Lcn/bestwu/api/sign/ApiSignProperties;)V", "checkSign", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "sign", "", "requestParams", "Lorg/springframework/util/MultiValueMap;", "userAgent", "signParams", "signTime", "time", "", "signUserAgent", "skip", "", "Companion", "api-sign_main"})
public final class ApiSignAlgorithm {
    private final ApiSignProperties properties;
    private static final Logger log;
    public static final Companion Companion;

    public final void checkSign(@NotNull HttpServletRequest request) {
        int clientTimeDifference;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        String signParameter = this.properties.getSignParameter();
        String sign = request.getHeader(signParameter);
        if (sign == null) {
            sign = request.getParameter(signParameter);
        }
        if (this.skip(request)) {
            return;
        }
        if (!StringUtils.hasText((String)sign)) {
            if (ApiSignAlgorithm.Companion.getLog().isDebugEnabled()) {
                ApiSignAlgorithm.Companion.getLog().debug("\u5ba2\u6237\u7aef\u7b7e\u540d\u4e3a\u7a7a");
            }
            throw (Throwable)new InvalidRequestException();
        }
        String string = sign;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        if (string.length() != 32) {
            if (ApiSignAlgorithm.Companion.getLog().isDebugEnabled()) {
                ApiSignAlgorithm.Companion.getLog().debug("\u5ba2\u6237\u7aef\u7b7e\u540d\u957f\u5ea6\u4e0d\u5339\u914d{}\uff1a{}", (Object)sign.length(), (Object)sign);
            }
            throw (Throwable)new InvalidRequestException();
        }
        String string2 = this.signParams();
        int n2 = 0;
        int n3 = 16;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n2, n3);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String signParams = string4;
        string2 = sign;
        n2 = 0;
        n3 = 16;
        String string5 = string2;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n2, n3);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        if (!StringsKt.equals((String)string6, (String)signParams, (boolean)true)) {
            if (ApiSignAlgorithm.Companion.getLog().isDebugEnabled()) {
                string2 = sign;
                n2 = 0;
                n3 = 16;
                String string7 = "\u5ba2\u6237\u7aef\u53c2\u6570\u7b7e\u540d\u9519\u8bef,\u5ba2\u6237\u7aef\uff1a{}\uff0c\u670d\u52a1\u7aef\uff1a{}";
                Logger logger = ApiSignAlgorithm.Companion.getLog();
                String string8 = string2;
                if (string8 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.substring(n2, n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string10 = string9;
                logger.debug(string7, (Object)string10, (Object)signParams);
            }
            throw (Throwable)new InvalidRequestException();
        }
        if (this.properties.isUserAgent()) {
            String string11 = ApiSignAlgorithm.signUserAgent$default(this, null, 1, null);
            n3 = 16;
            n = 24;
            String string12 = string11;
            if (string12 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string13 = string12.substring(n3, n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String signUserAgent = string13;
            string11 = sign;
            n3 = 16;
            n = 24;
            String string14 = string11;
            if (string14 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string15 = string14.substring(n3, n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (!StringsKt.equals((String)string15, (String)signUserAgent, (boolean)true)) {
                if (ApiSignAlgorithm.Companion.getLog().isDebugEnabled()) {
                    string11 = sign;
                    n3 = 16;
                    n = 24;
                    String string16 = "\u5ba2\u6237\u7aefUserAgent\u7b7e\u540d\u9519\u8bef,\u5ba2\u6237\u7aef\uff1a{}\uff0c\u670d\u52a1\u7aef\uff1a{}";
                    Logger logger = ApiSignAlgorithm.Companion.getLog();
                    String string17 = string11;
                    if (string17 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string18 = string17.substring(n3, n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string18, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string19 = string18;
                    logger.debug(string16, (Object)string19, (Object)signUserAgent);
                }
                throw (Throwable)new InvalidRequestException();
            }
        }
        if ((clientTimeDifference = this.properties.getClientTimeDifference()) > 0) {
            String string20 = sign;
            n = 24;
            int n4 = 32;
            String string21 = string20;
            if (string21 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string22 = string21.substring(n, n4);
            Intrinsics.checkExpressionValueIsNotNull((Object)string22, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String signTime = string22;
            long time = System.currentTimeMillis() / (long)(clientTimeDifference * 1000);
            String string23 = this.signTime(time);
            int n5 = 24;
            int n6 = 32;
            String string24 = string23;
            if (string24 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string25 = string24.substring(n5, n6);
            Intrinsics.checkExpressionValueIsNotNull((Object)string25, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (!StringsKt.equals((String)string25, (String)signTime, (boolean)true)) {
                string23 = this.signTime(time - (long)1);
                n5 = 24;
                n6 = 32;
                String string26 = string23;
                if (string26 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string27 = string26.substring(n5, n6);
                Intrinsics.checkExpressionValueIsNotNull((Object)string27, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                if (!StringsKt.equals((String)string27, (String)signTime, (boolean)true)) {
                    string23 = this.signTime(time + (long)1);
                    n5 = 24;
                    n6 = 32;
                    String string28 = string23;
                    if (string28 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string29 = string28.substring(n5, n6);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string29, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    if (!StringsKt.equals((String)string29, (String)signTime, (boolean)true)) {
                        if (ApiSignAlgorithm.Companion.getLog().isDebugEnabled()) {
                            string23 = sign;
                            n5 = 24;
                            n6 = 32;
                            String string30 = "\u5ba2\u6237\u7aef\u65f6\u95f4\u7b7e\u540d\u9519\u8bef,\u5ba2\u6237\u7aef\uff1a{}";
                            Logger logger = ApiSignAlgorithm.Companion.getLog();
                            String string31 = string23;
                            if (string31 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string32 = string31.substring(n5, n6);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string32, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            String string33 = string32;
                            logger.debug(string30, (Object)string33);
                        }
                        throw (Throwable)new InvalidRequestException();
                    }
                }
            }
        }
        if (ApiSignAlgorithm.Companion.getLog().isDebugEnabled()) {
            ApiSignAlgorithm.Companion.getLog().debug("\u7b7e\u540d\u9a8c\u8bc1\u901a\u8fc7");
        }
    }

    @NotNull
    public final String sign(@NotNull MultiValueMap<String, String> requestParams, @NotNull String userAgent) {
        Intrinsics.checkParameterIsNotNull(requestParams, (String)"requestParams");
        Intrinsics.checkParameterIsNotNull((Object)userAgent, (String)"userAgent");
        return this.signParams(requestParams) + this.signUserAgent(userAgent) + this.signTime(System.currentTimeMillis() / (long)this.properties.getClientTimeDifference());
    }

    @NotNull
    public final String sign(@NotNull MultiValueMap<String, String> requestParams) {
        Intrinsics.checkParameterIsNotNull(requestParams, (String)"requestParams");
        return this.signParams(requestParams) + this.signUserAgent("") + this.signTime(System.currentTimeMillis() / (long)this.properties.getClientTimeDifference());
    }

    private final String signTime(long time) {
        String timestamp = String.valueOf(time);
        String string = timestamp = timestamp + this.properties.getClient_secret();
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string3 = DigestUtils.md5DigestAsHex((byte[])byArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"DigestUtils.md5DigestAsH\u2026(timestamp.toByteArray())");
        timestamp = string3;
        return timestamp;
    }

    private final String signUserAgent(String userAgent) {
        String useragent = userAgent;
        if (useragent == null) {
            useragent = "";
        }
        String string = useragent = useragent + this.properties.getClient_secret();
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string3 = useragent = DigestUtils.md5DigestAsHex((byte[])byArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"useragent");
        return string3;
    }

    static /* bridge */ /* synthetic */ String signUserAgent$default(ApiSignAlgorithm apiSignAlgorithm, String string, int n, Object object) {
        if ((n & 1) != 0) {
            HttpServletRequest httpServletRequest = ApiSignAlgorithm.Companion.getRequest();
            if (httpServletRequest == null) {
                Intrinsics.throwNpe();
            }
            string = httpServletRequest.getHeader("user-agent");
        }
        return apiSignAlgorithm.signUserAgent(string);
    }

    /*
     * WARNING - void declaration
     */
    private final String signParams() {
        HttpServletRequest httpServletRequest = ApiSignAlgorithm.Companion.getRequest();
        if (httpServletRequest == null) {
            Intrinsics.throwNpe();
        }
        Map requestParams = httpServletRequest.getParameterMap();
        ArrayList keys = new ArrayList(requestParams.keySet());
        Collections.sort(keys);
        StringBuilder prestr = new StringBuilder("");
        for (String key : keys) {
            int length;
            int n;
            int n2;
            String[] values = (String[])requestParams.get(key);
            StringBuilder value = new StringBuilder();
            if (values == null) {
                Intrinsics.throwNpe();
            }
            if ((n2 = 0) <= (n = (length = ((Object[])values).length) - 1)) {
                while (true) {
                    void i;
                    value.append(values[i]);
                    value.append(i == length - 1 ? "" : ",");
                    if (i == n) break;
                    ++i;
                }
            }
            if (Intrinsics.areEqual((Object)value.toString(), (Object)"") || StringsKt.equals((String)key, (String)"sign", (boolean)true) || StringsKt.equals((String)key, (String)"sign_type", (boolean)true)) continue;
            prestr.append(key).append("=").append((CharSequence)value).append("&");
        }
        if (ApiSignAlgorithm.Companion.getLog().isDebugEnabled()) {
            ApiSignAlgorithm.Companion.getLog().debug("\u5f85\u7b7e\u540d\u53c2\u6570\u5b57\u7b26\u4e32\uff1a{}", (Object)prestr);
        }
        StringBuilder stringBuilder = prestr.append(this.properties.getClient_secret());
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"prestr.append(properties.client_secret)");
        prestr = stringBuilder;
        String string = prestr.toString();
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string3 = DigestUtils.md5DigestAsHex((byte[])byArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"DigestUtils.md5DigestAsH\u2026toString().toByteArray())");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private final String signParams(MultiValueMap<String, String> requestParams) {
        ArrayList keys = new ArrayList(requestParams.keySet());
        Collections.sort(keys);
        StringBuilder prestr = new StringBuilder("");
        for (String key : keys) {
            int length;
            int n;
            int n2;
            List values = (List)requestParams.get((Object)key);
            StringBuilder value = new StringBuilder();
            List list = values;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            if ((n2 = 0) <= (n = (length = list.size()) - 1)) {
                while (true) {
                    void i;
                    value.append((String)values.get((int)i));
                    value.append(i == length - 1 ? "" : ",");
                    if (i == n) break;
                    ++i;
                }
            }
            if (Intrinsics.areEqual((Object)value.toString(), (Object)"") || StringsKt.equals((String)key, (String)"sign", (boolean)true) || StringsKt.equals((String)key, (String)"sign_type", (boolean)true)) continue;
            prestr.append(key).append("=").append((CharSequence)value).append("&");
        }
        if (ApiSignAlgorithm.Companion.getLog().isDebugEnabled()) {
            ApiSignAlgorithm.Companion.getLog().debug("\u5f85\u7b7e\u540d\u53c2\u6570\u5b57\u7b26\u4e32\uff1a{}", (Object)prestr);
        }
        StringBuilder stringBuilder = prestr.append(this.properties.getClient_secret());
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"prestr.append(properties.client_secret)");
        prestr = stringBuilder;
        String string = prestr.toString();
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string3 = DigestUtils.md5DigestAsHex((byte[])byArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"DigestUtils.md5DigestAsH\u2026toString().toByteArray())");
        return string3;
    }

    private final boolean skip(HttpServletRequest request) {
        if (this.properties.isCanSkip()) {
            Boolean skip_sign;
            Object object = request.getAttribute("SKIP_SIGN");
            if (!(object instanceof Boolean)) {
                object = null;
            }
            Boolean bl = skip_sign = (Boolean)object;
            return bl != null ? bl : false;
        }
        return false;
    }

    public ApiSignAlgorithm(@NotNull ApiSignProperties properties) {
        Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
        this.properties = properties;
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(ApiSignAlgorithm.class);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rR\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcn/bestwu/api/sign/ApiSignAlgorithm$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "request", "Ljavax/servlet/http/HttpServletRequest;", "getRequest", "()Ljavax/servlet/http/HttpServletRequest;", "skip", "", "api-sign_main"})
    public static final class Companion {
        private final Logger getLog() {
            return log;
        }

        public final void skip() {
            HttpServletRequest httpServletRequest = this.getRequest();
            if (httpServletRequest == null) {
                Intrinsics.throwNpe();
            }
            httpServletRequest.setAttribute("SKIP_SIGN", (Object)true);
        }

        private final HttpServletRequest getRequest() {
            ServletRequestAttributes requestAttributes;
            RequestAttributes requestAttributes2 = RequestContextHolder.getRequestAttributes();
            if (!(requestAttributes2 instanceof ServletRequestAttributes)) {
                requestAttributes2 = null;
            }
            ServletRequestAttributes servletRequestAttributes = requestAttributes = (ServletRequestAttributes)requestAttributes2;
            return servletRequestAttributes != null ? servletRequestAttributes.getRequest() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

