/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.api.sign;

import cn.bestwu.api.sign.AbstractApiSignAlgorithm;
import cn.bestwu.api.sign.ApiSignProperties;
import cn.bestwu.api.sign.InvalidRequestException;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Base64Utils;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

public class UserAgentApiSignAlgorithm
extends AbstractApiSignAlgorithm {
    protected UserAgentApiSignAlgorithm(ApiSignProperties properties) {
        super(properties);
    }

    @Override
    protected String loadClientSignKeyByClientId(String client_id) {
        return this.properties.getClient_secret();
    }

    @Override
    public void checkSign(HttpServletRequest request) {
        String signParameter = this.properties.getSignParameter();
        String sign = request.getHeader(signParameter);
        if (sign == null) {
            sign = request.getParameter(signParameter);
        }
        if (this.skip(request)) {
            return;
        }
        if (!StringUtils.hasText((String)sign)) {
            if (log.isDebugEnabled()) {
                log.debug("\u5ba2\u6237\u7aef\u7b7e\u540d\u4e3a\u7a7a");
            }
            throw new InvalidRequestException();
        }
        Object[] strings = new String(Base64Utils.decodeFromString((String)sign)).split(":");
        if (strings.length != 2) {
            if (log.isDebugEnabled()) {
                log.debug("\u5ba2\u6237\u7aef\u7b7e\u540d\u89e3\u7801\uff1a{}", (Object)Arrays.toString(strings));
            }
            throw new InvalidRequestException();
        }
        String timestamp = strings[0];
        if (!StringUtils.hasText((String)timestamp)) {
            if (log.isDebugEnabled()) {
                log.debug("timestamp\u4e3a\u7a7a");
            }
            throw new InvalidRequestException();
        }
        if (Math.abs(System.currentTimeMillis() - Long.parseLong(timestamp)) > 600000L) {
            if (log.isDebugEnabled()) {
                log.debug("\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u5ba2\u6237\u7aef\u65f6\u95f4\uff1a{}", (Object)new Date(System.currentTimeMillis()).toString(), (Object)new Date(Long.parseLong(timestamp)).toString());
            }
            throw new InvalidRequestException();
        }
        String serviceSign = UserAgentApiSignAlgorithm.sign(request.getParameterMap(), DigestUtils.md5DigestAsHex((byte[])request.getHeader("user-agent").getBytes()), this.properties.getClient_secret(), timestamp);
        if (!((String)strings[1]).equalsIgnoreCase(serviceSign)) {
            if (log.isDebugEnabled()) {
                log.debug("\u670d\u52a1\u7aef\u7b7e\u540d\uff1a" + serviceSign);
            }
            throw new InvalidRequestException();
        }
        if (log.isDebugEnabled()) {
            log.debug("\u7b7e\u540d\u9a8c\u8bc1\u901a\u8fc7");
        }
    }

    @Override
    protected String base64Sign(String sign, String client_id, String timestamp) {
        return Base64Utils.encodeToString((byte[])(timestamp + ":" + sign).getBytes());
    }
}

