/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.api.sign;

import cn.bestwu.api.sign.AbstractApiSignAlgorithm;
import cn.bestwu.api.sign.ApiSignProperties;
import cn.bestwu.api.sign.InvalidRequestException;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

public abstract class ClientApiSignAlgorithm
extends AbstractApiSignAlgorithm {
    protected ClientApiSignAlgorithm(ApiSignProperties properties) {
        super(properties);
    }

    @Override
    public void checkSign(HttpServletRequest request) {
        String signParameter = this.properties.getSignParameter();
        String sign = request.getHeader(signParameter);
        if (sign == null) {
            sign = request.getParameter(signParameter);
        }
        if (this.skip(request)) {
            return;
        }
        if (!StringUtils.hasText((String)sign)) {
            if (log.isDebugEnabled()) {
                log.debug("\u5ba2\u6237\u7aef\u7b7e\u540d\u4e3a\u7a7a");
            }
            throw new InvalidRequestException();
        }
        Object[] strings = new String(Base64Utils.decodeFromString((String)sign)).split(":");
        if (strings.length != 3) {
            if (log.isDebugEnabled()) {
                log.debug("\u5ba2\u6237\u7aef\u7b7e\u540d\u89e3\u7801\uff1a{}", (Object)Arrays.toString(strings));
            }
            throw new InvalidRequestException();
        }
        String client_id = strings[0];
        Object timestamp = strings[1];
        if (!StringUtils.hasText((String)client_id)) {
            if (log.isDebugEnabled()) {
                log.debug("client_id\u4e3a\u7a7a");
            }
            throw new InvalidRequestException();
        }
        if (!StringUtils.hasText((String)timestamp)) {
            if (log.isDebugEnabled()) {
                log.debug("timestamp\u4e3a\u7a7a");
            }
            throw new InvalidRequestException();
        }
        if (Math.abs(System.currentTimeMillis() - Long.parseLong((String)timestamp)) > 600000L) {
            if (log.isDebugEnabled()) {
                log.debug("\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u5ba2\u6237\u7aef\u65f6\u95f4\uff1a{}", (Object)new Date(System.currentTimeMillis()).toString(), (Object)new Date(Long.parseLong((String)timestamp)).toString());
            }
            throw new InvalidRequestException();
        }
        String serviceSign = ClientApiSignAlgorithm.sign(request.getParameterMap(), client_id, this.loadClientSignKeyByClientId(client_id), (String)timestamp);
        if (!((String)strings[2]).equalsIgnoreCase(serviceSign)) {
            if (log.isDebugEnabled()) {
                log.debug("\u670d\u52a1\u7aef\u7b7e\u540d\uff1a" + serviceSign);
            }
            throw new InvalidRequestException();
        }
        if (log.isDebugEnabled()) {
            log.debug("\u7b7e\u540d\u9a8c\u8bc1\u901a\u8fc7");
        }
    }

    @Override
    protected String base64Sign(String sign, String client_id, String timestamp) {
        return Base64Utils.encodeToString((byte[])(client_id + ":" + timestamp + ":" + sign).getBytes());
    }
}

