/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.api.sign;

import cn.bestwu.api.sign.ApiSignAlgorithm;
import cn.bestwu.api.sign.ApiSignAspect;
import cn.bestwu.api.sign.ApiSignProperties;
import cn.bestwu.api.sign.DefaultClientApiSignAlgorithm;
import cn.bestwu.api.sign.SimpleApiSignAlgorithm;
import cn.bestwu.api.sign.UserAgentApiSignAlgorithm;
import org.springframework.aop.SpringProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={SpringProxy.class})
@ConditionalOnProperty(prefix="api.sign", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={ApiSignProperties.class})
public class ApiSignConfiguration {
    @Autowired
    private ApiSignProperties properties;

    @Bean
    public ApiSignAspect apiSignAspect() {
        return new ApiSignAspect();
    }

    @Bean
    @ConditionalOnMissingBean(value={ApiSignAlgorithm.class})
    public ApiSignAlgorithm defaultApiSign() {
        switch (this.properties.getMode()) {
            case SIMPLE: {
                return new SimpleApiSignAlgorithm(this.properties);
            }
            case USER_AGENT: {
                return new UserAgentApiSignAlgorithm(this.properties);
            }
            case CLIENT: {
                return new DefaultClientApiSignAlgorithm(this.properties);
            }
        }
        return new SimpleApiSignAlgorithm(this.properties);
    }
}

