/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.api.sign;

import cn.bestwu.api.sign.ApiSignAlgorithm;
import cn.bestwu.api.sign.ApiSignProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class AbstractApiSignAlgorithm
implements ApiSignAlgorithm {
    protected static Logger log = LoggerFactory.getLogger(AbstractApiSignAlgorithm.class);
    protected final ApiSignProperties properties;

    protected AbstractApiSignAlgorithm(ApiSignProperties properties) {
        this.properties = properties;
    }

    public static String sign(Map<String, String[]> requestParams, String client_id, String client_secret, String timestamp) {
        ArrayList<String> keys = new ArrayList<String>(requestParams.keySet());
        Collections.sort(keys);
        StringBuilder prestr = new StringBuilder("");
        for (String key : keys) {
            String[] values = requestParams.get(key);
            String value = "";
            int length = values.length;
            for (int i = 0; i < length; ++i) {
                value = value + values[i];
                value = value + (i == length - 1 ? "" : ",");
            }
            if (value == null || value.equals("") || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("sign_type")) continue;
            prestr.append(key).append("=").append(value).append("&");
        }
        if (StringUtils.hasText((String)client_id)) {
            prestr.append(client_id).append("&").append(timestamp);
        } else {
            prestr.append(timestamp);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5f85\u7b7e\u540d\u53c2\u6570\u5b57\u7b26\u4e32\uff1a{}", (Object)prestr);
        }
        prestr = prestr.append("{").append(client_secret).append("}");
        return DigestUtils.md5DigestAsHex((byte[])prestr.toString().getBytes());
    }

    public static String sign(MultiValueMap<String, String> requestParams, String client_id, String client_secret, String timestamp) {
        ArrayList keys = new ArrayList(requestParams.keySet());
        Collections.sort(keys);
        StringBuilder prestr = new StringBuilder("");
        for (String key : keys) {
            List values = (List)requestParams.get((Object)key);
            String value = "";
            int length = values.size();
            for (int i = 0; i < length; ++i) {
                value = value + (String)values.get(i);
                value = value + (i == length - 1 ? "" : ",");
            }
            if (value == null || value.equals("") || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("sign_type")) continue;
            prestr.append(key).append("=").append(value).append("&");
        }
        if (StringUtils.hasText((String)client_id)) {
            prestr.append(client_id).append("&").append(timestamp);
        } else {
            prestr.append(timestamp);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5f85\u7b7e\u540d\u53c2\u6570\u5b57\u7b26\u4e32\uff1a{}", (Object)prestr);
        }
        prestr = prestr.append("{").append(client_secret).append("}");
        return DigestUtils.md5DigestAsHex((byte[])prestr.toString().getBytes());
    }

    protected boolean skip(HttpServletRequest request) {
        if (this.properties.isCanSkip()) {
            Boolean skip_sign = (Boolean)request.getAttribute("SKIP_SIGN");
            return skip_sign == null ? false : skip_sign;
        }
        return false;
    }

    public static void skip() {
        AbstractApiSignAlgorithm.getRequest().setAttribute("SKIP_SIGN", (Object)true);
    }

    private static HttpServletRequest getRequest() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        return requestAttributes.getRequest();
    }

    @Override
    public String sign(Map<String, String[]> requestParams, String client_id) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        return this.base64Sign(AbstractApiSignAlgorithm.sign(requestParams, client_id, this.loadClientSignKeyByClientId(client_id), timestamp), client_id, timestamp);
    }

    @Override
    public String sign(MultiValueMap<String, String> requestParams, String client_id) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        return this.base64Sign(AbstractApiSignAlgorithm.sign(requestParams, client_id, this.loadClientSignKeyByClientId(client_id), timestamp), client_id, timestamp);
    }

    protected abstract String loadClientSignKeyByClientId(String var1);

    protected abstract String base64Sign(String var1, String var2, String var3);
}

