package cn.bestwu.api.sign;

import java.util.Arrays;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

/**
 * 简单签名适配
 * <p>
 * 默认签名算法为MD5
 * <p>
 * SIGN_TYPE = "MD5";
 *
 * @author Peter Wu
 */
public class SimpleApiSignAlgorithm extends AbstractApiSignAlgorithm {


  protected SimpleApiSignAlgorithm(ApiSignProperties properties) {
    super(properties);
  }

  @Override
  protected String loadClientSignKeyByClientId(String client_id) {
    return properties.getClient_secret();
  }

  @Override
  public void checkSign(HttpServletRequest request) {
    String signParameter = properties.getSignParameter();
    String sign = request.getHeader(signParameter);
    if (sign == null) {
      sign = request.getParameter(signParameter);
    }

    if (skip(request)) {
      return;
    }
    if (!StringUtils.hasText(sign)) {
      if (log.isDebugEnabled()) {
        log.debug("客户端签名为空");
      }
      throw new InvalidRequestException();
    }
    String[] strings = new String(Base64Utils.decodeFromString(sign)).split(":");
    if (strings.length != 2) {
      if (log.isDebugEnabled()) {
        log.debug("客户端签名解码：{}", Arrays.toString(strings));
      }
      throw new InvalidRequestException();
    }
    String timestamp = strings[0];
    if (!StringUtils.hasText(timestamp)) {
      if (log.isDebugEnabled()) {
        log.debug("timestamp为空");
      }
      throw new InvalidRequestException();
    }
    if (Math.abs(System.currentTimeMillis() - Long.parseLong(timestamp)) > 10 * 60 * 1000) {
      if (log.isDebugEnabled()) {
        log.debug("当前时间：{}，客户端时间：{}", new Date(System.currentTimeMillis()).toString(),
            new Date(Long.parseLong(timestamp)).toString());
      }
      throw new InvalidRequestException();
    }
    String serviceSign = sign(request.getParameterMap(),
        null,
        properties.getClient_secret(), timestamp);
    if (!strings[1].equalsIgnoreCase(serviceSign)) {
      if (log.isDebugEnabled()) {
        log.debug("服务端签名：" + serviceSign);
      }
      throw new InvalidRequestException();
    }
    if (log.isDebugEnabled()) {
      log.debug("签名验证通过");
    }
  }

  @Override
  protected String base64Sign(String sign, String client_id, String timestamp) {
    return Base64Utils.encodeToString((timestamp + ":" + sign).getBytes());
  }
}
