package cn.bestwu.api.sign;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 签名配置属性
 *
 * @author Peter Wu
 */
@ConfigurationProperties("api.sign")
public class ApiSignProperties {

  /**
   * 是否简单签名模式
   */
  private AlgorithmMode mode = AlgorithmMode.SIMPLE;

  /**
   * 是否可跳过验证
   */
  private boolean canSkip = true;

  /**
   * 客户端ID参数名
   */
  private String client_idParameter = "client_id";
  /**
   * 签名参数名
   */
  private String signParameter = "sign";
  /**
   * 默认客户端ID
   */
  private String client_id;
  /**
   * 默认客户端密码
   */
  private String client_secret;

  //--------------------------------------------

  public AlgorithmMode getMode() {
    return mode;
  }

  public void setMode(AlgorithmMode mode) {
    this.mode = mode;
  }

  public boolean isCanSkip() {
    return canSkip;
  }

  public void setCanSkip(boolean canSkip) {
    this.canSkip = canSkip;
  }

  public String getClient_idParameter() {
    return client_idParameter;
  }

  public void setClient_idParameter(String client_idParameter) {
    this.client_idParameter = client_idParameter;
  }

  public String getSignParameter() {
    return signParameter;
  }

  public void setSignParameter(String signParameter) {
    this.signParameter = signParameter;
  }

  public String getClient_id() {
    return client_id;
  }

  public void setClient_id(String client_id) {
    this.client_id = client_id;
  }

  public String getClient_secret() {
    return client_secret;
  }

  public void setClient_secret(String client_secret) {
    this.client_secret = client_secret;
  }
}
