package cn.bestwu.api.sign;

import org.springframework.aop.SpringProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 接口签名 自动配置
 *
 * @author Peter Wu
 */
@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass({SpringProxy.class})
@ConditionalOnProperty(prefix = "api.sign", name = "enabled", havingValue = "true", matchIfMissing = true)
@EnableConfigurationProperties({ApiSignProperties.class})
public class ApiSignConfiguration {

  @Autowired
  private ApiSignProperties properties;

  /**
   * @return 签名验证切面
   */
  @Bean
  public ApiSignAspect apiSignAspect() {
    return new ApiSignAspect();
  }

  /**
   * @return 默认签名算法
   */
  @Bean
  @ConditionalOnMissingBean(ApiSignAlgorithm.class)
  public ApiSignAlgorithm defaultApiSign() {
    switch (properties.getMode()) {
      case SIMPLE:
        return new SimpleApiSignAlgorithm(properties);
      case USER_AGENT:
        return new UserAgentApiSignAlgorithm(properties);
      case CLIENT:
        return new DefaultClientApiSignAlgorithm(properties);
    }
    return new SimpleApiSignAlgorithm(properties);
  }
}