package cn.bestwu.api.sign;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.MultiValueMap;

/**
 * 请求签名
 *
 * @author Peter Wu
 */
public interface ApiSignAlgorithm {

  /**
   * 验证
   *
   * @param request 请求
   */
  void checkSign(HttpServletRequest request);

  /**
   * @param requestParams 请求参数
   * @param client_id 客户端ID
   * @return 签名
   */
  String sign(Map<String, String[]> requestParams, String client_id);

  /**
   * @param requestParams 请求参数
   * @param client_id 客户端ID
   * @return 签名
   */
  String sign(MultiValueMap<String, String> requestParams, String client_id);
}
