package cn.bestwu.api.sign;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 注解需要签名验证的接口，可注解在类上，或{@code RequestMapping}注解的方法上
 * <pre class="code">
 *
 * &#064;ApiSign
 * &#064;RestController
 * public class TestController {
 *
 * &#064;RequestMapping(value = "/test", method = RequestMethod.POST)
 * public Object test() {
 * return "test";
 * }
 *
 * }
 * </pre>
 * <pre class="code">
 *
 * &#064;RestController
 * public class TestController {
 *
 * &#064;ApiSign
 * &#064;RequestMapping(value = "/test", method = RequestMethod.POST)
 * public Object test() {
 * return "test";
 * }
 *
 * }
 * </pre>
 *
 * @author Peter Wu
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface ApiSign {

}
