package cn.benguo.xm.push.route.action;

import android.content.Context;
import android.text.TextUtils;

import com.spinytech.macore.MaActionResult;
import com.xiaomi.mipush.sdk.MiPushClient;

import java.util.HashMap;

import cn.benguo.core.push.RouteOperator;

/**
 * Created by pyt on 2017/3/27.
 */

public class OnUnBindAccountAction extends BaseAction {
    @Override
    public MaActionResult invoke(Context context, HashMap<String, String> requestData) {
        log(requestData.toString());
        String account = requestData.get("account");
        if (TextUtils.isEmpty(account)) {
            return getCommonErrorResult("account is null");
        }

        if (MiPushClient.aliasSetTime(context.getApplicationContext(), account) < 0L) {
            RouteOperator.receiveCommandResult(context, "20005", "-1", account, "Don't cancel account for [" + account + "] is unseted");
        } else {
            MiPushClient.unsetAlias(context.getApplicationContext(),account,null);
        }

        return getCommonSuccessResult();
    }
}
